import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.BreadthFirstIterator;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceEdge;

import javax.xml.crypto.Data;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.*;

public class Messures {

    public static void main(String ... args) throws IOException {
        String filePath = "Data/com-dblp.ungraph.txt";
        Graph g = new DefaultGraph("g");
        FileSource fs = new FileSourceEdge();
        fs.addSink(g);
        try {
            fs.readAll(filePath);
            //g.display();
        } catch( IOException e) {
            e.printStackTrace();
        } finally {
            fs.removeSink(g);
        }
        System.out.println("*************************************************");
        System.out.println("La question numéro 2:");
        System.out.println("Le nb de noeds de ce graphe est :"+g.getNodeCount());
        System.out.println("Le nb d'arêtes de ce graphe est :"+g.getEdgeCount());
        System.out.println("Le degré moyen de ce graphe est :"+(Toolkit.averageDegree(g)));
        System.out.println("Le coefficient de clustering de ce graphe est :"+Toolkit.averageClusteringCoefficient(g));
        System.out.println("Le coefficient de clustering pour ce réseau aléatoire  est :"+Toolkit.averageDegree(g)/g.getNodeCount());
        System.out.println("*************************************************");
        System.out.println("La question numéro 3:");
        System.out.println("Le réseau est-il connexe ?"+Toolkit.isConnected(g));
        System.out.println("  Un réseau aléatoire de la même taille et degré moyen sera-t-il connexe ?"+ "NON");
        System.out.println("À partir de quel degré moyen un réseau aléatoire avec cette taille devient connexe? "+(int)Math.ceil(Math.log(317080)));
        System.out.println("*************************************************");
        System.out.println("La question numéro 4:");
        int[] dd = Toolkit.degreeDistribution(g);
        String filename = "Data/dd_dblp.dat";
        try {
            String filepath=System.getProperty("user.dir")+ File.separator+filename;
            System.out.println("Ecriture du fichier : "+filepath);
            FileWriter fw = new FileWriter(filepath);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int k = 0; k < dd.length; k++) {
                String line = "";
                if (dd[k] != 0) {
                    bw.write(String.format(Locale.US, "%6d%20.8f%n", k, (double)dd[k] / g.getNodeCount()));
                }
            }
            bw.close();
        }catch(IOException e) {
            e.printStackTrace();
        }
        System.out.println("*************************************************");
        System.out.println("La question numéro 5:");
        System.out.println("Ça prend du temps pour calculer la distance moyenne.....");
        List<Node> l = Toolkit.randomNodeSet(g,1000);
        HashMap<Integer, Integer> distancesMap = new HashMap<Integer, Integer>();
        double distance=0;
        int nb=0;
        for(int i=0;i<1000;i++){
            BreadthFirstIterator<Node> bfi = new BreadthFirstIterator<Node>(l.get(i));
            while(bfi.hasNext()) {
                Node opNode = bfi.next();
                int key = bfi.getDepthOf(opNode);
                if (distancesMap.containsKey(key)) {
                    int t = distancesMap.get(key);
                    int value = 1 + t;
                    distancesMap.put(key, value);
                } else {
                    distancesMap.put(key, 1);
                }
                distance += bfi.getDepthOf(bfi.next());
                nb++;
            }
        }
        double distanceMoy = distance/(nb);
        System.out.println("La distance moyenne est calculée avec 1000 sommets choisis au hasard :"+distanceMoy);
        System.out.println("La distance moyenne dans un réseau aléatoire avec les mêmes caractéristiques est :"+Math.log(g.getNodeCount())/Math.log(Toolkit.averageDegree(g)));

            String filename1 = "Data/lesdistances.dat";
            try {
                String filepath=System.getProperty("user.dir")+ File.separator+filename1;
                System.out.println("Ecriture du fichier : "+filepath);
                FileWriter fw = new FileWriter(filepath);
                BufferedWriter bw = new BufferedWriter(fw);
                for (Integer name: distancesMap.keySet()){
                        bw.write(String.format(Locale.US, "%6d%20.8f%n", name, (double)distancesMap.get(name) / nb));

                }
                bw.close();
            }catch(IOException e) {
                e.printStackTrace();
            }




    }
}

