package ovh.quinta.sncf_lh

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import kotlinx.coroutines.*
import kotlinx.serialization.json.JsonArray
import ovh.quinta.sncf_lh.databinding.FragmentFirstBinding

/**
 * A simple [Fragment] subclass as the default destination in the navigation.
 */
class FirstFragment : Fragment() {
    private var _binding: FragmentFirstBinding? = null

    // This property is only valid between onCreateView and
    // onDestroyView.
    private val binding get() = _binding!!

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentFirstBinding.inflate(inflater, container, false)
        return binding.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        runBlocking {
            val arrivalsDataset = TrainData(JsonArray(emptyList()), JsonArray(emptyList()))
            val departuresDataset = TrainData(JsonArray(emptyList()), JsonArray(emptyList()))
            val arrivalsAdapter = ArrivalsAdapter(arrivalsDataset)
            val departuresAdapter = ArrivalsAdapter(departuresDataset)
            val arrivalsRV: RecyclerView = view.findViewById(R.id.arrivalsRV)
            val departuresRV: RecyclerView = view.findViewById(R.id.departuresRV)
            val arrivalsLlm = LinearLayoutManager(arrivalsRV.context, LinearLayoutManager.VERTICAL, false)
            val departuresLlm = LinearLayoutManager(departuresRV.context, LinearLayoutManager.VERTICAL, false)
            arrivalsRV.adapter = arrivalsAdapter
            arrivalsRV.layoutManager = arrivalsLlm
            departuresRV.adapter = departuresAdapter
            departuresRV.layoutManager = departuresLlm
            val arrivalsFetcher = DataFetcher("https://api.navitia.io/v1/coverage/sncf/stop_areas/stop_area%3ASNCF%3A87413013/arrivals", arrivalsDataset, "arrivals")
            val departuresFetcher = DataFetcher("https://api.navitia.io/v1/coverage/sncf/stop_areas/stop_area%3ASNCF%3A87413013/departures", departuresDataset, "departures")
            super.onViewCreated(view, savedInstanceState)
            launch {
                arrivalsFetcher.start()
                departuresFetcher.start()
                while(arrivalsFetcher.isAlive || departuresFetcher.isAlive) delay(50)
            }
        }
    }
    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }
}
