package ovh.quinta.sncf_lh

import androidx.recyclerview.widget.RecyclerView
import kotlinx.serialization.json.*
import java.io.BufferedReader
import java.net.URL

class DataFetcher(url: String, private var dataset: TrainData, private val requestedObject: String) : Thread() {
    private val apikey = "7e9768dd-6c22-4325-9570-33d13e05e959"
    private val url: URL = URL(url)
    override fun run() {
        val conn = url.openConnection()
        conn.setRequestProperty("Authorization", apikey)
        val result = conn.getInputStream().bufferedReader().use(BufferedReader::readText)
        val json = Json.parseToJsonElement(result)
        val arrivals = json.jsonObject[requestedObject] ?: return
        val arrayArrivals = arrivals.jsonArray
        val sortedArrivals = arrayArrivals.sortedWith(compareBy {
            Json.decodeFromJsonElement<String>(
                it.jsonObject["stop_date_time"]!!.jsonObject["arrival_date_time"]!!
            )
        })
        dataset.arrivals = sortedArrivals
    }
}