package ovh.quinta.sncf_lh

import android.graphics.Color
import android.graphics.Paint
import android.opengl.Visibility
import android.os.Build
import android.text.TextPaint
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.annotation.RequiresApi
import androidx.core.view.isGone
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import kotlinx.serialization.json.*
import java.time.Instant
import java.time.format.DateTimeFormatter
import java.util.*


class ArrivalsAdapter(private val dataSet: TrainData) :
    RecyclerView.Adapter<ArrivalsAdapter.ViewHolder>() {

    /**
     * Provide a reference to the type of views that you are using
     * (custom ViewHolder).
     */
    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val trainId: TextView
        val predictedArrivalTime: TextView
        val arrivalTime: TextView

        init {
            // Define click listener for the ViewHolder's View.
            trainId = view.findViewById(R.id.txtTrainId)
            arrivalTime = view.findViewById(R.id.txtArrivalTime)
            predictedArrivalTime = view.findViewById(R.id.txtPredictedTime)
        }
    }

    // Create new views (invoked by the layout manager)
    override fun onCreateViewHolder(viewGroup: ViewGroup, viewType: Int): ViewHolder {
        // Create a new view, which defines the UI of the list item
        val view = LayoutInflater.from(viewGroup.context)
            .inflate(R.layout.recycler_view_item, viewGroup, false)

        return ViewHolder(view)
    }

    // Replace the contents of a view (invoked by the layout manager)
    @RequiresApi(Build.VERSION_CODES.O)
    override fun onBindViewHolder(viewHolder: ViewHolder, position: Int) {
        val train: JsonObject = dataSet.arrivals[position].jsonObject
        val displayInfos = train["display_informations"]?.jsonObject
        if(displayInfos == null) {
            viewHolder.trainId.text = "Invalid data for this train"
            return
        }
        viewHolder.trainId.text = "${Json.decodeFromJsonElement<String>(displayInfos["commercial_mode"]!!)} - ${Json.decodeFromJsonElement<String>(displayInfos["trip_short_name"]!!)}"

        val stopDateTime = train["stop_date_time"]!!.jsonObject
        val stringPredictedArrivalDate = Json.decodeFromJsonElement<String>(stopDateTime["base_arrival_date_time"]!!)
        val stringArriveDate = Json.decodeFromJsonElement<String>(stopDateTime["arrival_date_time"]!!)
        val txtPredictedArrival = viewHolder.predictedArrivalTime
        if(stringPredictedArrivalDate != stringArriveDate) {
            txtPredictedArrival.isVisible = true
        }else {
            txtPredictedArrival.isVisible = false
            txtPredictedArrival.isGone = true
        }
        val inDateFormat = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss")
        val arriveDate = inDateFormat.parse(stringArriveDate)
        val predictedArrivalDate = inDateFormat.parse(stringPredictedArrivalDate)
        val outDateFormat = DateTimeFormatter.ofPattern("hh':'mm")
        viewHolder.arrivalTime.text = outDateFormat.format(arriveDate)
        viewHolder.predictedArrivalTime.text = outDateFormat.format(predictedArrivalDate)
    }

    // Return the size of your dataset (invoked by the layout manager)
    override fun getItemCount() = dataSet.arrivals.size
}
