// Create a WebSocket connection to the server
const ws = new WebSocket("ws://" + window.location.host+ "/socket");

// We get notified once connected to the server
ws.onopen = (event) => {
    console.log("We are connected.");
};

ws.onmessage = (event) => {
    console.log(event.data);
};

const SerialPort = require('serialport');
const Readline = require('@serialport/parser-readline');
let state = 0;

var port = new SerialPort('COM8', {
    baudRate: 9600,
});

const parser = port.pipe(new Readline({delimiter: '\n'}));

// Read the port data
port.on("open", function () {
    console.log('open');
});

parser.on("data", data =>{
    /*if (state!==data)
    {
        state = data;
        console.log(state);
    }*/
    console.log("data :"+data+"\n");
    port.write(data+"\n");
});