import React, { Component } from 'react';
import NavBar from './NavBar.js';
import '../layout/Web.css';
import matchSorter from 'match-sorter';
import ReactTable from "react-table";
import { Button } from 'reactstrap';
import "react-table/react-table.css";
import 'bootstrap/dist/css/bootstrap.css';
import Modal from "react-modal";


/* ---------------------------------------------- */

class ListeStage extends Component {

    constructor(props, context) {
        super(props, context);
        this.openModal = this.openModal.bind(this);
        this.closeModal = this.closeModal.bind(this);
        this.onAdd = this.onAdd.bind(this);


        this.state = {

    offre : [],
    nomEntreprise: [],
    columns: [
      {
        Header: "Intitulé de l'offre",
            id: "intitule_offre",
            accessor: d => d.intitule_offre,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["intitule_offre"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Référence de l'offre",
            id: "ref_offre",
            accessor: d => d.ref_offre,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["ref_offre"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Entreprise",
            id: "nom_entreprise",
            accessor: d => d.nom_entreprise,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["nom_entreprise"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Année de l'offre",
        id: "annee_offre",
        accessor: d => d.annee_offre,
        filterMethod: (filter, rows) =>
        matchSorter(rows, filter.value, { keys: ["annee_offre"] }),
        filterAll: true,
        show: true
  },

],
        modalIsOpen: false
  }
}

componentDidMount(){
  this.getOffre();
  this.getNomEntreprise();
}

getOffre = _ => {
  fetch('http://localhost:4000/offre')
  .then(response => response.json())
  .then(
    response =>
      this.setState({
        offre : response.data}))
  .catch(err => console.error(err))
}

getNomEntreprise = _ => {
  console.log("GetNomEntreprise");

  fetch('http://localhost:4000/entrepriseNom')
  .then(response => response.json())
  .then(
    response =>
      this.setState({
        nomEntreprise : response.data}))
  .catch(err => console.error(err))
}

openModal() {
    this.setState({modalIsOpen: true});
}

closeModal() {
    this.setState({modalIsOpen: false});
}

onAdd(){
    let intitule = document.getElementById("intitule").value;
    let ref = document.getElementById("ref").value;
    let entreprise = document.getElementById("entreprise").value;
    let annee = document.getElementById("annee").value;
    let idEntreprise;

    for(let i = 0; i < this.state.nomEntreprise.length; i++) {
      if(this.state.nomEntreprise[i].nom_entreprise === entreprise) {
        idEntreprise = this.state.nomEntreprise[i].id_entreprise;
      }
    }

    var data = {
       intitule: intitule,
       ref:ref,
       entreprise: idEntreprise,
       annee: annee
    };
    // console.log(data);

  fetch("http://localhost:4000/ajoutOffre", {
      method: 'POST',
      headers: { "Content-Type": "application/json" },

      body: JSON.stringify(data)
  }).then(function(response) {
      if (response.status >= 400) {
        throw new Error("Bad response from server");
      }
      return response.json();
  }).then(function(data) {
      console.log(""+data)
  }).catch(function(err) {
      console.log(err)
  });

  this.setState({modalIsOpen: false});
}

toggleColumn = n => {
  const cols = this.state.columns.map((col, i) => n===i? {...col, show: !col.show}: col)
  this.setState({
    columns: cols
  })
}

createDataListNom() {
  var retour

  return retour;
}

  render() {
    return(
      <div className="App">
      {' '}
        <NavBar />

        <h1> Liste des Stages </h1>

        <div className="divButton" >

            Intitulé <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(1)} />{' '}
            Référence <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(2)} />{' '}
            Entreprise <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(3)} />{' '}
            Année <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(4)} />{' '}
            <Button onClick={this.openModal}>Open Modal</Button>
        </div>

        <ReactTable
            data={this.state.offre}
          filterable
          defaultFilterMethod={(filter, row) =>
            String(row[filter.id_offre]) === filter.value}
          columns={this.state.columns}
          defaultPageSize={10}
          className="-striped -highlight"
        />

        <Modal
                  isOpen={this.state.modalIsOpen}
                  onRequestClose={this.closeModal}
                  contentLabel="Example Modal"
                >

                  <h2 ref={subtitle => this.subtitle = subtitle}>Ajouter une offre de stage :</h2>
                  <form>
                      <label> Intitulé : <input type="text" name="intitule" id="intitule"/> </label> <br/>
                      <label> Référence : <input type="text" name="ref" id="ref"/> </label> <br/>
                      <label> Entreprise : <input type="text" list="nomEntreprise" name="entreprise" id="entreprise"/>
                      <datalist id="nomEntreprise" >
                      {this.state.nomEntreprise.map((nom) =>
                      <option value={nom.nom_entreprise}/>
                      )}
                      </datalist>
                       </label> <br/>
                      <label> Année : <input type="text" name="annee" id="annee"/> </label> <br/>
                  </form>
                  <div className="ButtonForm">

                  <Button onClick={this.closeModal}>Fermer</Button>{' '}{' '}{' '}
                  <Button onClick={this.onAdd}>Ajouter</Button>
                  </div>
                </Modal>
      </div>
    );
  }
}

export default ListeStage;
