import React, { Component } from 'react';
import NavBar from './NavBar.js';
import '../layout/Web.css';
import matchSorter from 'match-sorter';
import ReactTable from "react-table";
import { Button } from 'reactstrap';
import "react-table/react-table.css";
import 'bootstrap/dist/css/bootstrap.css';
import ListeStage from './listeStage.js';
import Modal from 'react-modal';
import {deactivateTooltips,getTooltip,check } from './controle.js';

class ListeEtudiant extends Component {
  constructor(props, context) {
        super(props, context);
        this.openModal = this.openModal.bind(this);
        this.closeModal = this.closeModal.bind(this);
        this.state = {
    student : [],
    columns: [
      {
        Header: "Prénom",
            id: "prenom",
            accessor: d => d.prenom,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["prenom"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Nom",
            id: "nom",
            accessor: d => d.nom,
            filterMethod: (filter, rows) =>
              matchSorter(rows, filter.value, { keys: ["nom"] }),
            filterAll: true,

            show: true
      },
      {
        Header: "Identifiant",
            id: "id_utilisateur",
            accessor: d => d.id_utilisateur,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["id_utilisateur"] }),
            filterAll: true,

            show: true
      },
      {
        Header: "Profile",
            id: "profile",
            accessor: d => d.profile,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["profile"] }),
            filterAll: true,

            show: true
      },
      {
        Header: "Stage",
        accessor: "a_trouve_stage",
        id: "a_trouve_stage",
       //Cell: ({ value }) => (value === "oui" ? "oui" : "non"),
        filterMethod: (filter, row) => {
          if (filter.value === "all") {
            return true;
          }
          if (filter.value === "true") {
            return row[filter.id] ==="oui";
          }
          return row[filter.id] === "non";
        },
        Filter: ({ filter, onChange }) =>
          <select
            onChange={event => onChange(event.target.value)}
            style={{ width: "100%" }}
            value={filter ? filter.value : "all"}
          >
            <option value="all">Tout Montrer</option>
            <option value="true">Avec Stage</option>
            <option value="false">Sans Stage</option>
          </select>,

        show: true
  },

],
            modalIsOpen: false
  }
}



  componentDidMount(){
    this.getEtudiant();
  }
  getEtudiant = _ => {
    fetch('http://localhost:4000/etudiant')
    .then(response => response.json())
    .then(
      response =>
        this.setState({
          student : response.data}))
    .catch(err => console.error(err))
}

openModal() {
       this.setState({modalIsOpen: true});
   }

   closeModal() {
       this.setState({modalIsOpen: false});
   }


  toggleColumn = n => {
    const cols = this.state.columns.map((col, i) => n===i? {...col, show: !col.show}: col)
    this.setState({
      columns: cols
    })
  }
  render() {
    return(
      <div className="App">
      {' '}
        <NavBar />

        <h1> Liste des Etudiants </h1>

         <div className="divButton" >
        Prénom <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(0)} />{' '}
        Nom <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(1)} />{' '}
        Identifiant <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(2)} />{' '}
        Profil <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(3)} />{' '}
        Stage <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(4)} />{' '}
 <Button onClick={this.openModal}>Open Modal</Button>
        </div>

        <ReactTable
          data={this.state.student}
          filterable
          defaultFilterMethod={(filter, row) =>
            String(row[filter.id_utilisateur]) === filter.value}
          columns={this.state.columns}
          defaultPageSize={10}
          className="-striped -highlight"
        />

        <Modal
          isOpen={this.state.modalIsOpen}
          onRequestClose={this.closeModal}
          contentLabel="Example Modal"
        >

          <h2 ref={subtitle => this.subtitle = subtitle}>Ajouter un étudiant :</h2>
          <form id="myForm">

          <label class="form_col" for="lastName">Identifiant :</label>
          <input name="identifiant" id="identifiant" type="text" />
          <span class="tooltip">Un nom ne peut pas faire moins de 2 caractères</span>
          <br /><br />
         <label class="form_col" for="lastName">Nom :</label>
         <input name="lastName" id="lastName" type="text" />
         <span class="tooltip">Un nom ne peut pas faire moins de 2 caractères</span>
         <br /><br />
        <label class="form_col" for="firstName">Prénom :</label>
        <input name="firstName" id="firstName" type="text" />

        <span class="tooltip">Un prénom ne peut pas faire moins de 2 caractères</span>
        <br /><br />
        <label class="form_col" for="login">Profile :</label>
        <input name="Profile" id="Profile" type="text" />
        <span class="tooltip">Le profile ne peut pas faire moins de 2 caractères</span>
        <br /><br />
              <span class="form_col">Stage trouvé: </span>
                  <select name="stage" id="stage">
                      <option value="true">Oui</option>
                      <option value="false">Non</option>
              </select> <br/>
          </form>
          <div className="ButtonForm">
          <Button class="form_col" type="submit" onClick={this.closeModal}>Fermer</Button>{' '}{' '}{' '}
          <Button class="form_col" type="submit" onClick={this.closeModal}>Ajouter</Button>
          </div>
        </Modal>
      </div>
    );
  }
}

export default ListeEtudiant;
