import React, { Component } from 'react';
import NavBar from './NavBar.js';
import '../layout/Web.css';
import matchSorter from 'match-sorter';
import ReactTable from "react-table";
import { Button } from 'reactstrap';
import "react-table/react-table.css";
//import 'bootstrap/dist/css/bootstrap.css';
import Modal from "react-modal";




/* ---------------------------------------------- */

class ListeEntreprise extends Component {

  constructor(props, context) {
       super(props, context);

       this.openModal = this.openModal.bind(this);
       this.closeModal = this.closeModal.bind(this);
       this.onAdd = this.onAdd.bind(this);


       this.state = {
    entreprises : [],
    columns: [
      // {
      //   Header: "Numéro d'ID",
      //     id: "id_entreprise",
      //     accessor: d => d.id_entreprise,
      //     filterMethod: (filter, rows) =>
      //     matchSorter(rows, filter.value, { keys: ["id_entreprise"] }),
      //     filterAll: true,
      //
      //     show: true
      // },
      {
        Header: "Nom de l'entreprise",
            id: "nom_entreprise",
            accessor: d => d.nom_entreprise,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["nom_entreprise"] }),
            filterAll: true,

            show: true
      },
      {
        Header: "Type d'entreprise",
            id: "type_entreprise",
            accessor: d => d.type_entreprise,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["type_entreprise"] }),
            filterAll: true,

            show: true
      },
      {
        Header: "Raison Social",
            id: "raison_sociale",
            accessor: d => d.raison_sociale,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["raison_sociale"] }),
            filterAll: true,

            show: true
      },
      {
        Header: "Description de l'entreprise",
        id: "description",
        accessor: d => d.description,
        filterMethod: (filter, rows) =>
        matchSorter(rows, filter.value, { keys: ["description"] }),
        filterAll: true,

        show: true
      },
    ],
    nom_entreprise:'',
    type_entreprise:'',
    raison_social:'',
    description:'',
    modalIsOpen: false
  }
  }

  componentDidMount(){
    this.getEntreprise();
  }

  getEntreprise = _ => {
    fetch('http://localhost:4000/entreprise')
    .then(response => response.json())
    .then(
      response =>
        this.setState({
          entreprises : response.data}))
    .catch(err => console.error(err))
  }
      openModal() {
          this.setState({modalIsOpen: true});
      }

      closeModal() {
          this.setState({modalIsOpen: false});
      }

      onAdd(){
          let name = document.getElementById("name").value;
          let type = document.getElementById("type").value;
          let raison_sociale = document.getElementById("raison_sociale").value;
          let description = document.getElementById("description").value;

        var data = {
           nom_entreprise: name,
           type_entreprise:type,
           raison_sociale: raison_sociale,
           description: description
        };
        // console.log(data);

         fetch("http://localhost:4000/newDataEntreprise", {
          method: 'POST',
          headers: { "Content-Type": "application/json" },

          body: JSON.stringify(data)
      }).then(function(response) {
          if (response.status >= 400) {
            throw new Error("Bad response from server");
          }
          return response.json();
      }).then(function(data) {
          console.log(""+data)
      }).catch(function(err) {
          console.log(err)
      });

      this.setState({modalIsOpen: false});
    }

  toggleColumn = n => {
    const cols = this.state.columns.map((col, i) => n===i? {...col, show: !col.show}: col)
    this.setState({
      columns: cols
    })
  }

  render() {
    return(
      <div className="App">
      {' '}
        <NavBar />

        <h1> Liste des Entreprises </h1>

        <div className="divButton" >

            Nom <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(1)} />{' '}
            Type <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(2)} />{' '}
            Raison Social <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(3)} />{' '}
            Description <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(4)} />{' '}
            <Button onClick={this.openModal}>Open Modal</Button>
        </div>

        <ReactTable
          data={this.state.entreprises}
            filterable
          defaultFilterMethod={(filter, row) =>
            String(row[filter.id_offre]) === filter.value}
          columns={this.state.columns}
          defaultPageSize={10}
          className="-striped -highlight"
        />

        <Modal
             isOpen={this.state.modalIsOpen}
             onRequestClose={this.closeModal}
             contentLabel="Example Modal"
         >

             <h2 ref={subtitle => this.subtitle = subtitle}>Ajouter une entreprise :</h2>
             <form method="post" >
                 <label> Nom : <input type="text" name="nom_entreprise" id="name"/> </label> <br/>
                 <label> Type : <input type="text" name="type" id="type"/> </label> <br/>
                 <label> Raison Social : <input type="text" name="raison_social" id="raison_sociale"/> </label> <br/>
                 <label> Description : <input type="text" name="description" id="description"/> </label> <br/>
             </form>
<div className="ButtonForm">
             <Button onClick={this.closeModal}>Fermer</Button>{' '}{' '}{' '}
             <Button onClick={this.onAdd}>Ajouter</Button>
</div>
         </Modal>

      </div>
    );
  }
}

export default ListeEntreprise;
