import React, { Component } from 'react';
import NavBar from './NavBar.js';
import '../layout/Web.css';
import matchSorter from 'match-sorter';
import ReactTable from "react-table";
import { Button } from 'reactstrap';
import "react-table/react-table.css";
import 'bootstrap/dist/css/bootstrap.css';

var ladate = new Date()

//const CustomColumn = ({value}) => <span style={{ color: '#0000AA' }}>{value}</span>;

/* ---------------------------------------------- */

class App extends Component {
  state = {
    offre : [],
    columns: [
      {
        Header: "Intitulé de l'offre",
            id: "intitule_offre",
            accessor: d => d.intitule_offre,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["intitule_offre"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Référence de l'offre",
            id: "ref_offre",
            accessor: d => d.ref_offre,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["ref_offre"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Entreprise",
            id: "nom_entreprise",
            accessor: d => d.nom_entreprise,
            filterMethod: (filter, rows) =>
            matchSorter(rows, filter.value, { keys: ["nom_entreprise"] }),
            filterAll: true,
            show: true
      },
      {
        Header: "Année de l'offre",
        id: "annee_offre",
        accessor: d => d.annee_offre,
        filterMethod: (filter, rows) =>
        matchSorter(rows, filter.value, { keys: ["annee_offre"] }),
        filterAll: true,
        show: true
  },

    ]
  }
  componentDidMount(){
    this.getOffre();
  }
  getOffre = _ => {
    fetch('http://localhost:4000')
    .then(response => response.json())
    .then(
      response =>
        this.setState({
          offre : response.data}))
    .catch(err => console.error(err))
}

  toggleColumn = n => {
    const cols = this.state.columns.map((col, i) => n===i? {...col, show: !col.show}: col)
    this.setState({
      columns: cols
    })
  }

  render() {
    return(
      <div className="App">
      {' '}
        <NavBar />

        <h1> Accueil </h1>
        <div className="divButton" >
        ID <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(0)} />{' '}
        Intitulé <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(1)} />{' '}
        Référence <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(2)} />{' '}
        Entreprise <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(3)} />{' '}
        Année <input name="isGoing" type="checkbox" defaultChecked="true" onChange={() => this.toggleColumn(4)} />{' '}
        </div>

        <ReactTable
          data={this.state.offre}
          filterable
          defaultFilterMethod={(filter, row) =>
            String(row[filter.id_offre]) === filter.value}
          columns={this.state.columns}
          defaultPageSize={10}
          className="-striped -highlight"
        />

      </div>
    );
  }
}

export default App;
