import 'package:flutter/material.dart';
// Assurez-vous que le nom du fichier est correct
import 'google_sheets_api.dart';

void main() {
  // IMPORTANT : Assurez-vous que les widgets Flutter sont initialisés
  // avant d'appeler des fonctions qui utilisent 'rootBundle' (comme _getAuthClient)
  WidgetsFlutterBinding.ensureInitialized();
  runApp(MyApp());
}

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Test Google Sheets',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: TestSheetPage(),
    );
  }
}

class TestSheetPage extends StatefulWidget {
  @override
  _TestSheetPageState createState() => _TestSheetPageState();
}

class _TestSheetPageState extends State<TestSheetPage> {
  // Instance de votre classe API
  final GoogleSheetsApi api = GoogleSheetsApi();

  String _message = 'Appuyez sur un bouton pour tester.';
  bool _isLoading = false;

  // Fonction pour tester l'ajout
  Future<void> _testAppend() async {
    setState(() {
      _isLoading = true;
      _message = 'Ajout en cours...';
    });

    // Données d'exemple à ajouter
    final List<dynamic> row = [
      'Test depuis Flutter',
      DateTime.now().toIso8601String(), // Ajoute la date et l'heure actuelles
      'C\'est super !'
    ];

    final success = await api.appendData(row);

    setState(() {
      _isLoading = false;
      _message = success ? 'Ligne ajoutée avec succès !' : 'Échec de l\'ajout.';
    });
  }

  // Fonction pour tester la lecture
  Future<void> _testRead() async {
    setState(() {
      _isLoading = true;
      _message = 'Lecture en cours...';
    });

    final data = await api.readData();

    setState(() {
      _isLoading = false;
      if (data != null) {
        // Affiche les données lues (ou juste un message de succès)
        _message = 'Données lues avec succès:\n$data';
      } else {
        _message = 'Échec de la lecture des données.';
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text('Test Google Sheets API'),
      ),
      body: Center(
        child: Padding(
          padding: const EdgeInsets.all(16.0),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              // Affiche un indicateur de chargement ou les boutons
              if (_isLoading)
                CircularProgressIndicator()
              else
                Column(
                  children: [
                    ElevatedButton(
                      onPressed: _testAppend,
                      child: Text('1. Tester l\'ajout de ligne'),
                    ),
                    SizedBox(height: 20),
                    ElevatedButton(
                      onPressed: _testRead,
                      child: Text('2. Tester la lecture'),
                    ),
                  ],
                ),
              SizedBox(height: 30),
              // Affiche le message de statut
              Text(
                _message,
                textAlign: TextAlign.center,
              ),
            ],
          ),
        ),
      ),
    );
  }
}