import 'dart:convert';
import 'package:flutter/services.dart' show rootBundle;
import 'package:googleapis_auth/auth_io.dart' as auth;
import 'package:googleapis/sheets/v4.dart' as sheets;

class GoogleSheetsApi {

  // 1. Mettez l'ID de votre feuille ici (copié depuis l'URL)
  static const _spreadsheetId = '1tbWnNSx3J-OAM7rrAxU_YLM97z2zMFtV055nS66Ig3c';

  // 2. Définir les permissions
  static const _scopes = [sheets.SheetsApi.spreadsheetsScope];

  // 3. Fonction pour s'authentifier (utilise le fichier JSON)
  Future<auth.AutoRefreshingAuthClient?> _getAuthClient() async {
    try {
      final jsonString = await rootBundle.loadString('assets/credentials.json');
      final credentialsJson = json.decode(jsonString);

      final credentials = auth.ServiceAccountCredentials.fromJson(credentialsJson);

      final client = await auth.clientViaServiceAccount(credentials, _scopes);
      return client;
    } catch (e) {
      print('Erreur lors de l\'authentification : $e');
          return null;
      }
      }

  // 4. Fonction pour ajouter une nouvelle ligne
  Future<bool> appendData(List<dynamic> rowData) async {
    final client = await _getAuthClient();
    if (client == null) {
      print("Erreur d'authentification");
      return false;
    }

    final api = sheets.SheetsApi(client);

    // Le nom de votre feuille (ex: 'Feuille1')
    final String range = 'données etudiants';

    var values = sheets.ValueRange.fromJson({
      'values': [ rowData ] // Les données à ajouter
    });

    try {
      await api.spreadsheets.values.append(
          values,
          _spreadsheetId,
          range,
          valueInputOption: 'USER_ENTERED'
      );
      print('Données ajoutées !');
      client.close();
      return true;
    } catch (e) {
      print('Erreur lors de l\'ajout des données : $e');
      client.close();
      return false;
    }
  }

  // 5. Fonction pour lire des données (exemple)
  Future<List<List<dynamic>>?> readData() async {
    final client = await _getAuthClient();
    if (client == null) {
      print("Erreur d'authentification");
      return null;
    }

    final api = sheets.SheetsApi(client);

    // Exemple : lire la plage A1 à C10 de 'Feuille1'
    final String range = 'données etudiants!A1:C10';

    try {
      final result = await api.spreadsheets.values.get(
        _spreadsheetId,
        range,
      );
      print('Données lues : ${result.values}');
      client.close();
      return result.values;
    } catch (e) {
      print('Erreur lors de la lecture des données : $e');
      client.close();
      return null;
    }
  }
}