| PRENOM | NOM |
|---|---|
| MOUHAMED LAMINE| KEBE |
| PAPA ABDOULAYE | THIAM|
| MARYEM | MERROUK |
| ZAYNAB | DOUH |



# NFC_FLUTTER

Application Flutter de gestion de présence par **scan NFC** et/ou **QR Code**, avec enregistrement automatique dans **Google Sheets**.

---

##  Objectif

Permettre l’identification et l’émargement d’étudiants via :
- 📡 **NFC** (UID carte)
- 📷 **QR Code**

Les présences sont stockées automatiquement dans **Google Sheets**, sans base de données locale.

---

## Fonctionnalités

### Identification
- Scan **NFC**
- Scan **QR Code**
- Recherche automatique dans Google Sheets

### Présence
- Ajout d’un timestamp **ISO-8601**
- Historique concaténé dans **une seule cellule**
- Pas de doublon immédiat

### Inscription
- Page d’inscription dédiée
- Champs **pré-remplis automatiquement** après scan
- Scan NFC **directement depuis la page d’inscription**
- Un champ déjà rempli **n’est jamais écrasé**

### Données
- Lecture complète de Google Sheets
- Export et filtrage par date
- Génération de listes de présence

---

## Structure Google Sheets

Feuille attendue : **`données etudiants`**

| Colonne | Champ | Description |
|---:|---|---|
| A | N° étudiant | Identifiant unique |
| B | Prénom | Prénom |
| C | Nom | Nom |
| D | NFC | UID NFC |
| E | QR | Valeur QR |
| F | date_ajout | Historique des scans |

### Exemple (`date_ajout`)

2026-01-15T12:22:18.064921;
2026-01-15T12:23:17.172948;
2026-01-15T12:24:45.969633


---

##  Prérequis

- Flutter (canal stable recommandé)
- Android Studio + Android SDK
- Appareil Android **avec NFC**
- Compte Google Cloud
- API **Google Sheets v4** activée
- Service Account Google

---

##  Installation

### 1️⃣ Cloner le projet

```bash
git clone https://www-apps.univ-lehavre.fr/forge/tp240053/nfc_flutter.git
cd nfc_flutter
```

### 2️⃣ Installer les dépendances

flutter pub get

Google Sheets & Service Account
### 3️⃣ Credentials

Placer le fichier :

- assets/credentials.json

Déclarer dans pubspec.yaml :
```bash
flutter:
  assets:
	- assets/credentials.json
```

### 4️⃣ Partager la feuille

Dans Google Sheets :

Cliquer sur Partager

	Ajouter l’email du Service Account
	xxxx@xxxx.iam.gserviceaccount.com

	Rôle minimum : Éditeur

### 5️⃣ Configuration

Dans lib/google_sheets_api.dart :

	Vérifier _spreadsheetId

	Vérifier le nom de la feuille : données etudiants

▶ Exécution

- Sur un appareil Android connecté :
```bash

flutter run
```

## Utilisation

🔵 Scan NFC (page principale)

- Scanner une carte

- UID recherché en colonne D

- Si trouvé → timestamp ajouté en F

- Sinon → redirection vers Inscription avec NFC pré-rempli

🟢 Scan QR Code

- Scanner un QR

- Valeur recherchée en colonne E

- Même logique que NFC

✍️ Page Inscription (comportement clé)

- Tous les champs sont vides au départ

- Bouton Scanner NFC

- Lors du scan NFC :

-	L’UID est injecté automatiquement dans le champ NFC

		Le champ devient visible et éditable

- Si un champ est déjà rempli :

		❌ Il n’est jamais effacé

- Sélection d’un étudiant :

		Remplit uniquement les champs vides

🧠 Détails techniques
Google Sheets

	Écriture en mode RAW

	Index 1-based

	Historique concaténé avec ;

	Pas de base de données locale



✅ État du projet

✔️ Fonctionnel
✔️ NFC & QR
✔️ Inscription intelligente
✔️ Données persistantes
✔️ UX fluide

<video controls src="video/SVID_20260126_223946_1.mp4" title="Title">video demostration; dossier: video</video>
