import 'package:flutter/material.dart';
import 'google_sheets_api.dart';
import 'pdf_generator.dart';

class ExportPage extends StatefulWidget {
  const ExportPage({super.key});

  @override
  State<ExportPage> createState() => _ExportPageState();
}

class _ExportPageState extends State<ExportPage> {
  DateTime? selectedDate;
  final sheets = GoogleSheetsApi();

  Future<void> pickDate() async {
    final date = await showDatePicker(
      context: context,
      firstDate: DateTime(2024),
      lastDate: DateTime.now(),
      initialDate: DateTime.now(),
    );
    if (date != null) {
      setState(() => selectedDate = date);
    }
  }

  Future<void> export() async {
    final date = selectedDate!.toIso8601String().split('T')[0];
    final data = await sheets.getPresenceByDate(date);

    print("Data récupérée: $data"); // <-- AJOUTE ÇA
    if (data.isEmpty) {
      ScaffoldMessenger.of(context).showSnackBar(
        SnackBar(content: Text("Aucune donnée pour cette date")),
      );
      return;
    }

    await generatePdf(data, date);
    ScaffoldMessenger.of(context).showSnackBar(
      SnackBar(content: Text("PDF généré avec succès ✅")),
    );
  }


  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: const Text("Exporter présence")),
      body: Padding(
        padding: const EdgeInsets.all(20),
        child: Column(
          children: [
            ElevatedButton(
              onPressed: pickDate,
              child: const Text("Choisir une date"),
            ),
            if (selectedDate != null)
              Text("Date: ${selectedDate!.toString().substring(0, 10)}"),
            const SizedBox(height: 20),
            ElevatedButton(
              onPressed: selectedDate == null ? null : export,
              child: const Text("Générer le PDF"),
            )
          ],
        ),
      ),
    );
  }
}
