package edu.mermet.tp8.fenetres;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.UserXml;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.*;
import java.util.List;

/**
 * Classe permettant d'afficher une suggestion du jour
 */
public class FenetreSuggestion extends JDialog {

    private ResourceBundle
            bundleAstuces = ResourceBundle.getBundle("Astuces/astuces", Locale.FRENCH);

    private UserXml userXML;

    private String libelleAstuce;
    private String astuceAffichee;



    private JLabel lblMessage;

    private JPanel conteneurBtn;
    private JButton fermer;
    private JButton nePlusAfficher;

    private boolean aAfficher;

    private Application owner;

    /**
     * Constructeur FenetreSuggestion
     * @param u
     */
    public FenetreSuggestion(Application owner, UserXml u){
        //super("Suggestion du jour", false, true, false, false);
        super(owner,"Suggestion du jour", true);
        this.userXML = u;
        this.owner = owner;


        this.ajouterClesAstucesUserXML();
        this.tirerAstuceEnCours();


        this.lblMessage = new JLabel(this.astuceAffichee);
        this.add(lblMessage, BorderLayout.NORTH);

        this.conteneurBtn = new JPanel();

        this.fermer=new JButton(new ActionFermer());
        this.fermer.setText("Fermer");
        this.conteneurBtn.add(fermer);

        this.nePlusAfficher = new JButton(new ActionNePlusAfficher());
        this.nePlusAfficher.setText("Ne plus afficher");
        this.conteneurBtn.add(nePlusAfficher);

        this.add(conteneurBtn, BorderLayout.SOUTH);


        this.pack();
        //this.setDefaultCloseOperation(EXIT_ON_CLOSE);
        this.setLocationRelativeTo(null);
        this.setVisible(this.aAfficher);
    }

    /**
     * Ajoute les clés du fichier properties au fichier user.xml avec comme valeur par defaut (si non existantes) : true
     * Cela signifie que lorsqu'une clé du fichier user.xml a pour valeur true : elle peut potentiellement être affichée en suggestion du jour
     */
    public void ajouterClesAstucesUserXML(){
        Enumeration<String> cles = bundleAstuces.getKeys();

        while(cles.hasMoreElements()){
            String cle = cles.nextElement();
            if(userXML.getProperty(cle).equals("")){
                userXML.setProperty(cle, "true");
            }
        }

        userXML.save();

    }

    /**
     * Permet de tirer au hasard l'astuce à afficher
     */
    public void tirerAstuceEnCours(){

        List<String> listeLib = new ArrayList<>();
        listeLib.addAll(bundleAstuces.keySet());
        Collections.shuffle(listeLib);

        for(String astuce : listeLib){
            if(userXML.getProperty(astuce).equals("true")){
                this.libelleAstuce = astuce;
                break;
            }else{
                this.libelleAstuce = null;
            }
        }

        if(this.libelleAstuce == null) this.libelleAstuce = "";

        if(this.libelleAstuce.equals("")){
            this.astuceAffichee = "Aucune astuce";
            this.aAfficher = false;
        }
        else{
            this.astuceAffichee = this.getAstuceDepuisLibelle();
            this.aAfficher = true;
        }

    }

    /**
     * Retourne l'astuce associée au libellé stocké dans le fichier properties
     * @return String
     */
    public String getAstuceDepuisLibelle(){
            return bundleAstuces.getString(this.libelleAstuce);
    }

    /**
     * Classe permettant de quitter la fenêtre d'astuces
     */
    private class ActionFermer extends AbstractAction{
        public ActionFermer(){
            super("Fermer");
        }
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            setVisible(false);
        }
    }

    /**
     * Classe permettant de ne plus afficher l'astuce en cours
     */
    private class ActionNePlusAfficher extends AbstractAction{
        public ActionNePlusAfficher(){
            super("Ne plus afficher");
        }
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            setVisible(false);
            userXML.setProperty(libelleAstuce, "false");
            userXML.save();
        }
    }

}
