package edu.mermet.tp8;

/**
 * Classe gérant le level de l'utilisateur
 */
public class UserLevel {

	public static final int START_LEVEL = 10;
	private int level;

	/**
	 * Constructeur UserLevel
	 */
	public UserLevel() {
		this(START_LEVEL);
	}

	/**
	 * Constructeur UserLevel
	 * @param level
	 */
	public UserLevel(String level) {
		try {
			setLevel(Integer.parseInt(level));
			log("Niveau chargé : "+level);
		} catch(NumberFormatException | NullPointerException e) {
			log("Mauvais format pour un integer ("+ level +"), le niveau est mis à "+START_LEVEL);
			setLevel(START_LEVEL);
		}
	}

	/**
	 * Constructeur UserLevel
	 * @param level
	 */
	public UserLevel(int level) {
		setLevel(level);
	}

	/**
	 * Retourne le level de l'utilisateur
	 * @return int
	 */
	public int getLevel() {
		return level;
	}

	/**
	 * Applique un level à l'utilisateur
	 * @param level
	 */
	public void setLevel(int level) {
		this.level = level;
	}

	/**
	 * Ajoute le level passé en paramètre au level actuel de l'utilisateur
	 * @param toLevel
	 */
	public void add(int toLevel) {
		setLevel(toLevel+getLevel());
	}


	public void add(int toLevel, int limit) {
		if(getLevel() < limit) {
			add(toLevel);
		}
	}
	
	@Override
	public String toString() {
		return Double.toString(level);
	}

	/**
	 * Envoie le message passé en paramètre dans la console
	 * @param msg
	 */
	public void log(String msg) {
		System.out.println("UserLevel :: "+msg);
	}
}
