package edu.mermet.tp8;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.*;

import edu.mermet.tp8.fenetres.*;
import edu.mermet.tp8.fenetres.modales.CommentFaireDialogue;
import edu.mermet.tp8.fenetres.modales.ConfigurationMenusDialogue ;

/**
 *
 * @author brunomermet
 */
public class Application extends JFrame {
    private JInternalFrame conversion;
    private JInternalFrame texte;
    private JInternalFrame diaporama;
    private JInternalFrame boutons;

    private Action 
    	actionAfficherConversion = new ActionAfficherConversion(),
    	actionAfficherTexte = new ActionAfficherTexte(),
    	actionAfficherDiaporama = new ActionAfficherDiaporama(),
    	actionAfficherBoutons = new ActionAfficherBoutons(),
    	actionConfigMenus = new ActionConfigMenus(),
    	actionCommentFaire = new ActionCommentFaire(),
    	actionAideConversion = new ActionAideConversion(),
    	actionQuitter = new ActionQuitter();
    
    private UserXml userXml;
    private UserLevel userLevel;

    private FenetreSuggestion fs;

    private Application frameApp = this;

    private String utilisateur;

    public Application(String utilisateur) {
        super("multi-fenêtres");
        this.utilisateur = utilisateur;
        init();
    }

	private void init() {
        gestionLevel();
      
        contents();

        afficherConseil();

        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(600,300);
        setLocationRelativeTo(null);
        setVisible(true);
	}

	private void contents() {
		setContentPane(new JDesktopPane());
        barreDeMenu();
        creationFenetres();
	}

	private void barreDeMenu() {
        JMenuBar barre = new JMenuBar();
        menuFichier(barre);
        menuApplications(barre);
        menuAide(barre);
	}

	private void creationFenetres() {
        // ------ fenêtre conversion ------
        conversion = new FenetreConversion(actionAfficherConversion);
        this.add(conversion);
        // ------ fenêtre texte ------
        texte = new FenetreTexte(actionAfficherTexte);
        this.add(texte);
        // ------ fenêtre diaporama ------
        diaporama = new FenetreDiaporama(actionAfficherDiaporama);
        this.add(diaporama);
        // ------ fenêtre boutons ------
        boutons = new FenetreBoutons(this,actionAfficherBoutons);
        this.add(boutons);
	}

	 
  private void menuAide(JMenuBar barre) {
    JMenu menuAide = new JMenu("Aide");
    JMenuItem itemConfigMenus = new JMenuItem(actionConfigMenus);
    JMenuItem itemCommentFaire = new JMenuItem(actionCommentFaire);
    JMenuItem itemAideConversion   = new JMenuItem(actionAideConversion);
    menuAide.add (itemConfigMenus);
    menuAide.add (itemCommentFaire);
    menuAide.add(itemAideConversion);
    barre.add(menuAide);
  }
  
	private JMenuItem
		itemConversion = new JMenuItem(actionAfficherConversion),
		itemTexte = new JMenuItem(actionAfficherTexte),
		itemDiaporama = new JMenuItem(actionAfficherDiaporama),
		itemBoutons = new JMenuItem(actionAfficherBoutons);
  private void menuApplications(JMenuBar barre) {
        JMenu menuApplication = new JMenu("Applications");
        menuApplication.setMnemonic(KeyEvent.VK_A);
        menuApplication.add(itemConversion);
        menuApplication.add(itemTexte);
        menuApplication.add(itemDiaporama);
        menuApplication.add(itemBoutons);
        respectConfigurations();
        barre.add(menuApplication);
  }
  
  /*
   * méthode permettant de respecter la configuration voulue par l'utilisateur
   */
  public void respectConfigurations() {
        String prefSaisie = userXml.getProperty("saisie");
        String prefDiaporama = userXml.getProperty("diaporama");
        String prefBoutons = userXml.getProperty("boutons");
        String prefConversion = userXml.getProperty("conversion");
          
        if (prefSaisie.equals("Caché"))itemTexte.setVisible(false);
        else if (prefSaisie.equals("Affiche"))itemTexte.setVisible(true);

        if (prefDiaporama.equals("Caché"))itemDiaporama.setVisible(false) ;
        else if (prefDiaporama.equals("Affiche"))itemDiaporama.setVisible(true);

        if (prefBoutons.equals("Caché")) itemBoutons.setVisible(false);
        else if (prefBoutons.equals("Affiche"))itemBoutons.setVisible(true) ;

        if (prefConversion.equals("Caché")) itemConversion.setVisible(false); 
        else if (prefConversion.equals("Affiche"))itemConversion.setVisible(true);
  }

	private void menuFichier(JMenuBar barre) {
		// ------ menu Fichier ------
        JMenu menuFichier = new JMenu("Fichier");
        menuFichier.setMnemonic(KeyEvent.VK_F);
        JMenuItem quitter = new JMenuItem(actionQuitter);
        menuFichier.add(quitter);
        barre.add(menuFichier);
        this.setJMenuBar(barre);
	}

	private void gestionLevel() {
		userXml = new UserXml(utilisateur);
        userLevel = new UserLevel(userXml.getProperty("level"));
	}

	private void afficherConseil(){
        fs = new FenetreSuggestion(userXml);
        add(fs);
    }

	private class ActionQuitter extends AbstractAction {
		public ActionQuitter() {
			super("Quitter");
			putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_Q, InputEvent.CTRL_DOWN_MASK));
		}
		@Override
		public void actionPerformed(ActionEvent arg0) {
			userLevel.add(1, 40);
			userXml.setProperty("level", Integer.toString(userLevel.getLevel()));
			userXml.save();
			System.exit(0);
		}
		
	}
	
    private class ActionAfficherBoutons extends AbstractAction {
        public ActionAfficherBoutons() {
            super("Boutons");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_B, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_B);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boutons.setVisible(true);
            enableBoutons(false);
        }
    }

    private class ActionAfficherDiaporama extends AbstractAction {
        public ActionAfficherDiaporama() {
            super("Diaporama");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_D, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_D);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        	userLevel.add(2, 80);
            diaporama.setVisible(true);
            enableDiaporama(false);
        }
    }

    private class ActionAfficherTexte extends AbstractAction {
        public ActionAfficherTexte() {
            super("Saisie de texte");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_T);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            texte.setVisible(true);
            enableTexte(false);
        }
    }
    
    private class ActionCommentFaire extends AbstractAction {
      public ActionCommentFaire() {
          super("Comment faire ?");
      }

      @ Override
      public void actionPerformed ( ActionEvent e ) {
        new CommentFaireDialogue(frameApp);
      }
    }
      
    private class ActionConfigMenus extends AbstractAction {
        public ActionConfigMenus() {
            super("Configuration des menus");
        }

        @ Override
        public void actionPerformed ( ActionEvent e ) {
          new ConfigurationMenusDialogue(frameApp);
        }
      }

    private class ActionAideConversion extends AbstractAction{
        String message;

        public ActionAideConversion() {
            super("Aide conversion degrés");
            message="Fenetre de conversion de degrés \n \n" +
                    "Premier champ : saisie d'une valeur en degré Celsius \n" +
                    "Second champ : saisie d'une valeur en degré Farenheit";
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JOptionPane.showMessageDialog(frameApp, message, "Aide", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    public class ActionAfficherConversion extends AbstractAction {
        public ActionAfficherConversion() {
            super("Conversion Celsius/Farenheit");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_C);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        	userLevel.add(4, 160);
            conversion.setVisible(true);
            enableConversion(false);
        }
    }
    
    public Action getActionCommentFaire() {
      return actionCommentFaire;
    }
    
    public Action getActionConfigMenus() {
      return actionConfigMenus;
    }

    public void enableConversion(boolean b) {
        actionAfficherConversion.setEnabled(b);
    }

    public void enableTexte(boolean b) {
        actionAfficherTexte.setEnabled(b);
    }

    public void enableDiaporama(boolean b) {
        actionAfficherDiaporama.setEnabled(b);
    }

    public void enableBoutons(boolean b) {
        actionAfficherBoutons.setEnabled(b);
    }

    public Action getActionAfficherConversion() {
        return actionAfficherConversion;
    }

    public Action getActionAfficherTexte() {
        return actionAfficherTexte;
    }

    public Action getActionAfficherDiaporama() {
        return actionAfficherDiaporama;
    }

    public String getUtilisateur(){
        return this.utilisateur;
    }
    
    public UserXml getUserXml() {
    	return userXml;
    }
    
    public UserLevel getUserLevel() {
    	return userLevel;
    }
    
    public static void main(String[] args) {
        String str;
        if(args.length > 0){
            if(args[0] == null) str = System.getProperty("user.name");
            else str = args[0];
        }
        str = System.getProperty("user.name");

        final String finalStr = str;
        SwingUtilities.invokeLater(() -> {
            new Application(finalStr);
        });
    }
}
