package edu.mermet.tp8.fenetres.modales;

import edu.mermet.tp8.Application;

import java.awt.GridLayout ;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.*;
import java.util.Properties;

import javax.swing.BoxLayout ;
import javax.swing.ButtonGroup ;
import javax.swing.JButton ;
import javax.swing.JDialog ;
import javax.swing.JLabel ;
import javax.swing.JPanel ;
import javax.swing.JRadioButton ;

/**
 * Classe permettant de gérer les préférences utilisateur
 */
public class ConfigurationMenusDialogue extends JDialog {
    private JLabel conversion;
    private JLabel saisie;
    private JLabel diapo;
    private JLabel boutons;

    private JRadioButton conversionAuto;
    private JRadioButton saisieAuto;
    private JRadioButton diapoAuto;
    private JRadioButton boutonsAuto;

    private JRadioButton conversionAffiche;
    private JRadioButton saisieAffiche;
    private JRadioButton diapoAffiche;
    private JRadioButton boutonsAffiche;

    private JRadioButton conversionCache;
    private JRadioButton saisieCache;
    private JRadioButton diapoCache;
    private JRadioButton boutonsCache;

    private ButtonGroup convGroup;
    private ButtonGroup saisieGroup;
    private ButtonGroup diapoGroup;
    private ButtonGroup boutonsGroup;

    private JButton valider;
    private JButton annuler;

    private JPanel grille;
    private JPanel valAnn;

    private Application owner;

    /**
     * Constructeur ConfigurationMenusDialogue
     * @param owner
     */
    public ConfigurationMenusDialogue(Application owner) {
        super(owner,"Configuration des menus", true);
        this.owner = owner;
        init();
    }

    public void init() {
        contents();
        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }

    private void contents() {
        setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
        GridLayout grid = new GridLayout(4,4);
        grille = new JPanel(grid);
        valAnn = new JPanel();
        remplPanes();
        add(grille);
        add(valAnn);
    }

    private void remplPanes ( ) {
        convGroup = new ButtonGroup();
        conversion = new JLabel("Conversion Celsius/Farenheit"); grille.add(conversion);
        conversionAuto = new JRadioButton("Auto");conversionAuto.setActionCommand("Auto");grille.add(conversionAuto);
        conversionAffiche = new JRadioButton("Affiche");conversionAffiche.setActionCommand("Affiche");grille.add(conversionAffiche);
        conversionCache = new JRadioButton("Caché");conversionCache.setActionCommand("Caché");grille.add(conversionCache);
        convGroup.add (conversionAuto);convGroup.add (conversionAffiche);convGroup.add(conversionCache);

        saisieGroup = new ButtonGroup();
        saisie = new JLabel("Saisie de texte");grille.add(saisie);
        saisieAuto = new JRadioButton("Auto");saisieAuto.setActionCommand("Auto");grille.add(saisieAuto);
        saisieAffiche = new JRadioButton("Affiche");saisieAffiche.setActionCommand("Affiche");grille.add(saisieAffiche);
        saisieCache = new JRadioButton("Caché");saisieCache.setActionCommand("Caché");grille.add(saisieCache);
        saisieGroup.add (saisieAuto);saisieGroup.add (saisieAffiche);saisieGroup.add(saisieCache);

        diapoGroup = new ButtonGroup();
        diapo = new JLabel("Diaporama");grille.add(diapo);
        diapoAuto = new JRadioButton("Auto");diapoAuto.setActionCommand("Auto");grille.add(diapoAuto);
        diapoAffiche = new JRadioButton("Affiche");diapoAffiche.setActionCommand("Affiche");grille.add(diapoAffiche);
        diapoCache = new JRadioButton("Caché");diapoCache.setActionCommand("Caché");grille.add(diapoCache);
        diapoGroup.add (diapoAuto);diapoGroup.add (diapoAffiche);diapoGroup.add(diapoCache);

        boutonsGroup = new ButtonGroup();
        boutons = new JLabel("Boutons");grille.add(boutons);
        boutonsAuto = new JRadioButton("Auto");boutonsAuto.setActionCommand("Auto");grille.add(boutonsAuto);
        boutonsAffiche = new JRadioButton("Affiche");boutonsAffiche.setActionCommand("Affiche");grille.add(boutonsAffiche);
        boutonsCache = new JRadioButton("Caché");boutonsCache.setActionCommand("Caché");grille.add(boutonsCache);
        boutonsGroup.add (boutonsAuto);boutonsGroup.add (boutonsAffiche);boutonsGroup.add(boutonsCache);

        valider = new JButton("Valider");valAnn.add (valider);
        annuler = new JButton("Annuler");valAnn.add (annuler);

        //this.saisieAuto.setSelected(true);
        try {
            this.selectionnerJRadioButtons();
        } catch (IOException e) {
            e.printStackTrace();
        }

        valider.addActionListener(new EnregistrementPreferences());
    }

    public void selectionnerJRadioButtons() throws IOException {
        String propFileName = "src/main/resources/.ihm/" + owner.getUtilisateur() + ".xml";

        File tempFile = new File(propFileName);
        boolean fichierExiste = tempFile.exists();

        if (fichierExiste){
            try (InputStream input = new FileInputStream(propFileName)) {

                Properties prop = new Properties();

                prop.loadFromXML(input);

                String prefSaisie = prop.getProperty("saisie");
                String prefDiaporama = prop.getProperty("diaporama");
                String prefBoutons = prop.getProperty("boutons");
                String prefConversion = prop.getProperty("conversion");


                if (prefSaisie.equals("Caché")) this.saisieCache.setSelected(true);
                else if (prefSaisie.equals("Affiche")) this.saisieAffiche.setSelected(true);
                else this.saisieAuto.setSelected(true);

                if (prefDiaporama.equals("Caché")) this.diapoCache.setSelected(true);
                else if (prefDiaporama.equals("Affiche")) this.diapoAffiche.setSelected(true);
                else this.diapoAuto.setSelected(true);

                if (prefBoutons.equals("Caché")) this.boutonsCache.setSelected(true);
                else if (prefBoutons.equals("Affiche")) this.boutonsAffiche.setSelected(true);
                else this.boutonsAuto.setSelected(true);

                if (prefConversion.equals("Caché")) this.conversionCache.setSelected(true);
                else if (prefConversion.equals("Affiche")) this.conversionAffiche.setSelected(true);
                else this.conversionAuto.setSelected(true);


            }
         }
        else{
            this.saisieAffiche.setSelected(true);
            this.diapoAffiche.setSelected(true);
            this.boutonsAffiche.setSelected(true);
            this.conversionAffiche.setSelected(true);
        }


    }

    /**
     * Classe permettant de stocker les préférences de l'utilisateur
     */
    private class EnregistrementPreferences implements ActionListener {

        public EnregistrementPreferences(){}

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Properties properties = new Properties();

                if(convGroup.getSelection() != null)
                    properties.setProperty("conversion", convGroup.getSelection().getActionCommand());

                if(saisieGroup.getSelection() != null)
                    properties.setProperty("saisie", saisieGroup.getSelection().getActionCommand());

                if(diapoGroup.getSelection() != null)
                    properties.setProperty("diaporama", diapoGroup.getSelection().getActionCommand());

                if(boutonsGroup.getSelection() != null)
                    properties.setProperty("boutons", boutonsGroup.getSelection().getActionCommand());


                File file = new File("src/main/resources/.ihm/" + owner.getUtilisateur() + ".xml");

                FileOutputStream fileOut = new FileOutputStream(file);
                properties.storeToXML(fileOut, null);
                fileOut.close();


            } catch (FileNotFoundException ex) {
                ex.printStackTrace();
            } catch (IOException ioe) {
                ioe.printStackTrace();
            }

            dispose();
        }
    }

}
