package edu.mermet.tp8.fenetres.modales;

import edu.mermet.tp8.Application;

import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 * Classe gérant les indications en ce qui concerne les tutoriels
 */
public class CommentFaireDialogue extends JDialog {
    private ResourceBundle
            bundleTexte = ResourceBundle.getBundle("HowTo/textes", Locale.FRENCH),
            bundleTitre = ResourceBundle.getBundle("HowTo/titres", Locale.FRENCH);
    private JEditorPane editorPane;

    /**
     * Constructeur CommentFaireDialogue
     * @param owner
     */
    public CommentFaireDialogue(Application owner) {
        super(owner, false);
        init();
    }


    private void init() {
        contents();
        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }

    private void contents() {
    	setTitle(bundleTitre.getString("commentFaire"));
        setContentPane(new JSplitPane(JSplitPane.HORIZONTAL_SPLIT));
        initListe();
        initPageTuto();
    }

    private void initListe() {
        String[] items = {
                bundleTitre.getString("commentFaire"),
                bundleTitre.getString("conversionCF"),
                bundleTitre.getString("conversionFC"),
                bundleTitre.getString("gras"),
                bundleTitre.getString("couleur"),
                bundleTitre.getString("quitter")
        };
        JList<String> list = new JList<>(items);
        list.addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                String valeur = list.getSelectedValue();
                if(valeur.equals(bundleTitre.getString("commentFaire"))) {
                    editorPane.setText(bundleTexte.getString("tutoHowTo"));
                } else if(valeur.equals(bundleTitre.getString("conversionCF"))) {
                    editorPane.setText(bundleTexte.getString("tutoCF"));
                } else if(valeur.equals(bundleTitre.getString("conversionFC"))) {
                    editorPane.setText(bundleTexte.getString("tutoFC"));
                } else if(valeur.equals(bundleTitre.getString("quitter"))) {
                    dispose();
                } else if(valeur.equals(bundleTitre.getString("gras"))) {
                    editorPane.setText(bundleTexte.getString("tutoGras"));
                } else if(valeur.equals(bundleTitre.getString("couleur"))) {
                    editorPane.setText(bundleTexte.getString("tutoCouleur"));
                } else {
                    editorPane.setText(bundleTexte.getString("texteAccueil"));
                }
            }
        });
        add(list);
    }

    private void initPageTuto() {
        String texte = bundleTexte.getString("texteAccueil");
        editorPane = new JEditorPane("text/html", texte);
        editorPane.setEditable(false);
        add(editorPane);
    }
}
