package edu.mermet.tp8.fenetres;

import edu.mermet.tp8.UserXml;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

public class FenetreSuggestion extends JInternalFrame {

    private UserXml user;
    private String afficherPopUp;
    private boolean afficher;
    private static final String[] message={"Ctrl+C permet d'ouvrir la fenetre de conversion de degrés",
            "Ctrl+T permet d'ouvrir la fenetre pour saisir du texte",
            "Ctrl+D permet d'ouvrir le diaporama du Cotentin",
            "Ctrl+B permet d'ouvrir la fenetre des boutons",
            "L'option 'Diaporama' permet d'ouvrir un diaporama du Cotentin"};
    private int index;

    private JLabel lblMessage;

    private JPanel conteneurBtn;
    private JButton fermer;
    private JButton nePlusAfficher;

    public FenetreSuggestion(UserXml u){
        super("Suggestion du jour", false, true, false, false);
        user = u;

        afficherPopUp = user.getProperty("afficherPopUp");

        try{
            afficherPopUp.equals(null);
        }catch (NullPointerException npe){
            System.out.println("FenetreSuggestion :: La clé 'afficherPopUp' n'existe pas, création...");
            user.setProperty("afficherPopUp", "true");
            afficherPopUp = user.getProperty("afficherPopUp");
            user.save();
        }

        afficher = Boolean.parseBoolean(afficherPopUp);

        index = (int)(Math.random()*FenetreSuggestion.message.length);
        lblMessage = new JLabel(FenetreSuggestion.message[index]);
        add(lblMessage, BorderLayout.NORTH);

        conteneurBtn = new JPanel();

        fermer=new JButton(new ActionFermer());
        fermer.setText("Fermer");
        conteneurBtn.add(fermer);

        nePlusAfficher=new JButton(new ActionNePlusAfficher());
        nePlusAfficher.setText("Ne plus afficher");
        conteneurBtn.add(nePlusAfficher);

        add(conteneurBtn, BorderLayout.SOUTH);

        pack();
        setVisible(afficher);
    }

    private class ActionFermer extends AbstractAction{
        public ActionFermer(){
            super("Fermer");
        }
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            setVisible(false);
        }
    }

    private class ActionNePlusAfficher extends AbstractAction{
        public ActionNePlusAfficher(){
            super("Ne plus afficher");
        }
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            setVisible(false);
            user.setProperty("afficherPopUp", "false");
            user.save();
        }
    }

}
