package edu.mermet.tp8.fenetres;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.*;

/**
 *
 * @author brunomermet
 */
public class FenetreConversion extends AbstractFenetreInterne {
    private JTextField champCelsius;
    private JTextField champFarenheit;
    private JButton boutonConvertir;
    private Action actionConvertir;
    private boolean celsiusAFocus;

    public FenetreConversion(Action action) {
        super(action,"Conversion Celsius/Farenheit");
        this.setSize(new Dimension(100,50));
        this.setLayout(new GridLayout(3,1));

        ImageIcon iconAide = new ImageIcon("src/main/resources/images/icone_help.png");

        JPanel ligneCelsius = new JPanel();
        ligneCelsius.setLayout(new FlowLayout(FlowLayout.TRAILING));

        JLabel labCelsius = new JLabel("Celsius :");
        labCelsius.setToolTipText("Valeur en degrés Celsius");
        champCelsius = new JTextField(15);
        JMenuItem aideIconCelsius = new JMenuItem(new ActionAide("Celsius"));

        aideIconCelsius.setIcon(iconAide);

        labCelsius.setLabelFor(champCelsius);

        ligneCelsius.add(labCelsius);
        ligneCelsius.add(champCelsius);
        ligneCelsius.add(aideIconCelsius);

        this.add(ligneCelsius);

        celsiusAFocus = true;
        champCelsius.addFocusListener(new EcouteurFocus(true));
        JPanel ligneFarenheit = new JPanel();
        ligneFarenheit.setLayout(new FlowLayout(FlowLayout.TRAILING));

        JLabel labFarenheit = new JLabel("Farenheit :");
        labFarenheit.setToolTipText("Valeur en degrés Farenheit");
        champFarenheit = new JTextField(15);
        JMenuItem aideIconFarenheit = new JMenuItem(new ActionAide("Farenheit"));
        aideIconFarenheit.setIcon(iconAide);
        labFarenheit.setLabelFor(champFarenheit);

        ligneFarenheit.add(labFarenheit);
        ligneFarenheit.add(champFarenheit);
        ligneFarenheit.add(aideIconFarenheit);

        this.add(ligneFarenheit);

        champFarenheit.addFocusListener(new EcouteurFocus(false));
        JPanel ligneValider = new JPanel();
        ligneValider.setLayout(new FlowLayout(FlowLayout.CENTER));
        actionConvertir = new ActionConvertir();
        boutonConvertir = new JButton(actionConvertir);
        ligneValider.add(boutonConvertir);
        this.add(ligneValider);


        pack();
        getRootPane().setDefaultButton(boutonConvertir);
    }

    private class EcouteurFocus implements FocusListener {
        private boolean aStocker;

        public EcouteurFocus(boolean b) {
            aStocker = b;
        }

        @Override
        public void focusGained(FocusEvent fe) {
            celsiusAFocus = aStocker;
        }

        @Override
        public void focusLost(FocusEvent fe) {
            return;
        }
    }

    private class ActionAide extends AbstractAction{

        String unite;
        String message;
        public ActionAide(String source) {
            unite = source;
            message = "Valeur en degrés " + unite;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            // TODO Auto-generated method stub
            JOptionPane aide = new JOptionPane();
            aide.showMessageDialog(getParent(), message, "Aide", JOptionPane.INFORMATION_MESSAGE);
        }
    }

    private class ActionConvertir extends AbstractAction {

        public ActionConvertir() {
            super("Convertir");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            double tempCelsius = 0;
            double tempFarenheit = 0;
            if (celsiusAFocus) {
                try {
                    tempCelsius = Double.parseDouble(champCelsius.getText());
                tempFarenheit = 9./5*tempCelsius+32;
                champFarenheit.setText(""+tempFarenheit);
                }
                catch (NumberFormatException nfe) {
                    champFarenheit.setText("Format incorrect");
                }
                }
            else {
                try {
                    tempFarenheit = Double.parseDouble(champFarenheit.getText());
                    tempCelsius = (tempFarenheit - 32) *5./9;
                    champCelsius.setText(""+tempCelsius);
                }
                catch (NumberFormatException nfe) {
                    champCelsius.setText("Format incorrect");
                }

            }
        }
    }

}
