package edu.mermet.tp8;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UserXml {
	private String nom;
	private Properties properties;
	private String chemin;
	
	public UserXml() {
		this(System.getProperty("user.name"));
	}
	
	public UserXml(String nom) {
		this.nom = nom;
		properties = new Properties();
		chemin = "src/main/resources/.ihm/"+ nom +".xml";
		try {
			properties.loadFromXML(new FileInputStream(chemin));
		} catch (IOException e) {
			System.out.println("Fichier utilisateur de "+ nom +" non existant ! Création objet utilisateur avec propriétés vides.");
		}
	}
	
	public String getNom() {
		return nom;
	}
	
	public String getChemin() {
		return chemin;
	}
	
	public String getProperty(String key) {
		return properties.getProperty(key);
	}
	
	public Object setProperty(String key, String value) {
		return properties.setProperty(key, value);
	}
	
	public void save() {
		try {
			properties.storeToXML(new FileOutputStream(chemin), null);
		} catch (IOException e) {
			System.out.println("Erreur à l'enregistrement du fichier utilisateur.");
		}
	}
}
