package edu.mermet.tp8;

public class UserLevel {
	public static final int START_LEVEL = 10;
	private int level;
	
	public UserLevel() {
		this(START_LEVEL);
	}
	
	public UserLevel(String level) {
		try {
			setLevel(Integer.parseInt(level));
			log("Niveau chargé : "+level);
		} catch(NumberFormatException | NullPointerException e) {
			log("Mauvais format pour un integer ("+ level +"), le niveau est mis à "+START_LEVEL);
			setLevel(START_LEVEL);
		}
	}

	public UserLevel(int level) {
		setLevel(level);
	}
	
	public int getLevel() {
		return level;
	}
	
	public void setLevel(int level) {
		this.level = level;
	}
	
	public void add(int toLevel) {
		setLevel(toLevel+getLevel());
	}
	
	public void add(int toLevel, int limit) {
		if(getLevel() < limit) {
			add(toLevel);
		}
	}
	
	@Override
	public String toString() {
		return Double.toString(level);
	}
	
	public void log(String msg) {
		System.out.println("UserLevel :: "+msg);
	}
}
