const router = require('express').Router();
const pug = require('pug');
const bcrypt = require('bcrypt');

const saltRounds = 7;

const registerPug = pug.compileFile('pug/register.pug');

module.exports = User => router
  .get('/register', (req, res) => {
    let error = req.flash('error');
    let html;
    if(error != "") {
      html = registerPug({ error: error });
    } else {
      html = registerPug({ error: false });
    }
    res.send(html);
  })
  .post('/register', (req, res) => {
    if (req.body.username && req.body.password) {
      bcrypt.hash(req.body.password, saltRounds, (err, hash) => {
        if (err) {
          throw err;
        }
        User
          .findCreateFind({ where: { pseudo: req.body.username }, defaults: { mdp: hash } })
          .then(([user, created]) => {
            if (created) {
              res.redirect('/');
            } else {
              req.flash('error', 'This username is already used.');
              res.redirect('back');
            }
          });
      });
    } else {
      req.flash('error', 'You must use a non empty username and password.')
      res.redirect('back');
    }
  });