const router = require('express').Router();
const pug = require('pug');

const profilePug = pug.compileFile('pug/profile.pug');
const newPug = pug.compileFile('pug/profile/new.pug');

module.exports = (Sub, youtube) => router
  .get('/profile', guard, (req, res) => {
    let subs;
    req.user.getSubs()
      .then(array => {
        if (array.length == 0) {
          return Promise.reject(0); //si l'utilisateur n'a pas de subs on casse la chaîne pour éviter d'utiliser l'api youtube pour rien
        }
        subs = array;
        const ids = [];
        subs.forEach(sub => ids.push(sub.channel));
        return youtube.channels.list({
          part: 'snippet',
          id: ids.join(',')
        });
      })
      .then(response => {
        const ytList = {};
        //Youtube nous donne une liste de chaînes qui n'a pas le même ordre que la liste d'id qu'on a donné, j'utilise un objet comme tableau associatif pour récupérer les ressources en fonction de l'id
        response.data.items.forEach(item => ytList[item.id] = item.snippet);
        subs.forEach(sub => {
          sub.url = 'https://www.youtube.com/channel/' + sub.channel;
          sub.img = ytList[sub.channel].thumbnails.default.url;
          sub.title = ytList[sub.channel].title;
        });
        res.send(profilePug({ user: req.user, subs: subs }));
      })
      .catch(err => {
        if (err == 0) {
          res.send(profilePug({ user: req.user, subs: [] }));
        } else {
          console.log(err);
          res.redirect('/');
        }
      });
  })
  .get('/profile/new', guard, (req, res) => {
    res.send(newPug({ user: req.user }));
  })
  .post('/profile/new', guard, (req, res) => {
    Sub
      .create({
        UserId: req.user.id,
        keywords: req.body.q,
        channel: req.body.id
      })
      .then(res.redirect('/profile'));
  })
  .get('/profile/delete/:id', guard, (req, res) => {
    Sub.destroy({ where: {
      id: req.params.id,
      UserId: req.user.id //pour éviter de supprimer un sub de quelqu'un d'autre
    } })
    .then(n => res.redirect('/profile'))
    .catch(err => res.redirect('/profile'));    
  });

function guard(req, res, next) {
  if (req.user) {
    next();
  } else {
    res.redirect('/login');
  }
}