const router = require('express').Router();
const pug = require('pug');

const mysubsPug = pug.compileFile('pug/mysubs.pug');

module.exports = youtube => router
  .get('/mysubs', guard, (req, res) => {
    req.user.getSubs()
      .then(subs => {
        const promises = [];
        subs.forEach(sub => {
          promises.push(
            youtube.search.list({
              part: 'snippet',
              type: 'video',
              order: 'date',
              channelId: sub.channel,
              q: sub.keywords
            })
          )
        }); //On peut attendre plein de promesses à la fois grâce à Promise.all(), cela donne une grosse promesse
        return Promise.all(promises);
      })
      .then(responses => {
        console.log(responses);
        res.send(mysubsPug({ user: req.user, responses: responses }));
      })
      .catch(err => {
        console.log(err);
        res.redirect('/');
      })
  });

function guard(req, res, next) {
  if (req.user) {
    next();
  } else {
    res.redirect('/login');
  }
}