const router = require('express').Router();
const pug = require('pug');

const loginPug = pug.compileFile('pug/login.pug');

module.exports = passport => router
  .get('/login', (req, res) => {
    let html;
    let error = req.flash().error;
    if (error) {
      html = loginPug({ error: error[0] });
    } else {
      html = loginPug({ error: false })
    }
    res.send(html);
  })
  .post('/login', passport.authenticate('local', {
    successRedirect: '/',
    failureRedirect: '/login',
    failureFlash: true
  }));