const LocalStrategy = require('passport-local').Strategy;
const bcrypt = require('bcrypt');

module.exports = User => new LocalStrategy(
  (username, password, done) => {
    User
      .findOne({ where: { pseudo: username } })
      .then(user => {
        bcrypt.compare(password, user.mdp, (err, result) => {
          if (err) {
            throw err;
          }

          if (result) {
            return done(null, user);
          }

          return done(null, false, { message: 'Incorrect password.' });
        });
      })
      .catch(() => done(null, false, { message: 'Incorrect username.' }));
  }
);