const express = require('express');
const passport = require('passport');
const session = require('express-session');
const Sequelize = require('sequelize');
const bodyParser = require('body-parser');
const flash = require('connect-flash');
const fs = require('fs');
const { google } = require('googleapis');

const app = express();
const server = require('http').createServer(app);
const io = require('socket.io')(server);

app
  .use(express.static('public'))
  .use(session({ secret: 'cats', resave: false, saveUninitialized: false }))
  .use(bodyParser.urlencoded({ extended: false }))
  .use(passport.initialize())
  .use(passport.session())
  .use(flash());

const youtube = google.youtube({
  version: 'v3',
  auth: require('./getApiKeySync')
});

io.on('connection', socket => socket
  .on('channel', channel => {
    youtube.search.list({
      part: 'snippet',
      type: 'channel',
      maxResults: 3,
      q: channel
    })
      .then(res => {
        const array = [];
        res.data.items.forEach(item => {
          console.log(item);
          array.push({
            url: 'https://www.youtube.com/channel/' + item.id.channelId,
            img: item.snippet.thumbnails.default.url,
            description: item.snippet.description,
            title: item.snippet.channelTitle,
            id: item.id.channelId
          });
        });
        socket.emit('channels', array);
      });
  })
);

fs.readFile('config/config.json', (err, data) => {
  if (err) {
    throw err;
  }

  sequelizeAuthentication(new Sequelize(JSON.parse(data).development));
});

function sequelizeAuthentication(sequelize) {
  sequelize
    .authenticate()
    .then(() => {
      const User = require('./models/user')(sequelize, Sequelize.DataTypes);
      const Sub = require('./models/sub')(sequelize, Sequelize.DataTypes);
      User.associate({ Sub });
      Sub.associate({ User });
      passportConfiguration(User);
      routage(User, Sub);
    });
}

function passportConfiguration(User) {
  passport.use(require('./getLocalStrategy')(User));

  passport.serializeUser((user, done) => {
    done(null, user.id);
  });

  passport.deserializeUser((id, done) => {
    User
      .findByPk(id)
      .then(user => done(null, user))
      .catch(err => done(err, false));
  });
}

function routage(User, Sub) {
  app
    .use('/', require('./routes/login')(passport))
    .use('/', require('./routes/register')(User))
    .use('/', require('./routes/root'))
    .use('/', require('./routes/logout'))
    .use('/', require('./routes/mysubs')(youtube))
    .use('/', require('./routes/profile')(Sub, youtube));

  server.listen(3000, () => console.log('Site en ligne'));
}