import './index.css';
import nameGenerator from './name-generator';
import isDef from './is-def';

import {
    Sensor,
    Datum,
    SensorType,
    fSensorType
} from './class';

// Store/retrieve the name in/from a cookie.
const cookies = document.cookie.split(';');
console.log(cookies)
let wsname = cookies.find(function(c) {
  if (c.match(/wsname/) !== null) return true;
  return false;
});
if (isDef(wsname)) {
  wsname = wsname.split('=')[1];
} else {
  wsname = nameGenerator();
  document.cookie = "wsname=" + encodeURIComponent(wsname);
}

// Set the name in the header
document.querySelector('header>p').textContent = decodeURIComponent(wsname);

// Create a WebSocket connection to the server
const ws = new WebSocket("ws://127.0.0.1:1234");


// We get notified once connected to the server
ws.onopen = (event) => {
  console.log("We are connected.");
};

// Listen to messages coming from the server. When it happens, create a new <li> and append it to the DOM.
const messages = document.querySelector('#messages');





var mqtt = require('mqtt');
var client  = mqtt.connect('mqtt://127.0.0.1:1234');

client.subscribe("#");

client.on('connect', function () {
})

function ecriture(nom, type, valeur, moyenne){
    ligne = document.createElement('li');
    ligne.setAttribute("id", nom);
    ligne.textContent = nom + ", " + type + ", " + valeur + ", " + moyenne;

    messages.appendChild(ligne);
}
let ligne;
var capteurs = [];
var i = 0;

client.on('message', function (topic, message) {
    var objet = JSON.parse(message);
    var name = topic.split("/");

    var datum = new Datum(objet.value);
    var data = new Sensor(i,name[1],datum.value);
    var objetfinal = fSensorType(data, objet.type);


    if(capteurs.length === 0){
        objetfinal.incr = 1;
        objetfinal.total = objetfinal.data;
        objetfinal.moyenne = objetfinal.total;
        capteurs.push(objetfinal);
        ecriture(objetfinal.name, objet.type, objetfinal.data, "Moyenne : " + objetfinal.moyenne);
    }else{
        var j = verifElement(objetfinal);
        if(j !== -1){
            // si capteur a des valeurs numérique
            if(objetfinal.name === "temperatureChambre" || objetfinal.name === "temperatureSalleA111" || objetfinal.name === "MonAttention"){
                capteurs[j].incr = capteurs[j].incr + 1 ;
                capteurs[j].total = parseFloat(capteurs[j].total) + parseFloat(objetfinal.data) ;
                capteurs[j].moyenne = capteurs[j].total / capteurs[j].incr;
                capteurs[j].data = data;
                document.getElementById(objetfinal.name).textContent = objetfinal.name + ", " + objet.type + ", " + objetfinal.data + ", " + "Moyenne : " + capteurs[j].moyenne;
            }else{
                capteurs[j].data = data;
                document.getElementById(objetfinal.name).textContent = objetfinal.name + ", " + objet.type + ", " + objetfinal.data;
            }

        }
        else {  //si le capteur n'est pas présent alors on l'ajoute
            objetfinal.incr = 1;
            objetfinal.total = objetfinal.data;
            objetfinal.moyenne = objetfinal.total;
            capteurs.push(objetfinal);
            ecriture(objetfinal.name, objet.type, objetfinal.data, "Moyenne : " + objetfinal.moyenne);
        }
    }
    i++;
})

function verifElement(sensor){
    var j;
    var boolean = false;
    for( j =0; j<capteurs.length; j++){
        if(capteurs[j].name === sensor.name){
            return j;
        }
    }
    return -1;
}