export const version = () => "1.0.0";


export class Sensor {
    constructor(id, name, data) {
        this._id;
        this.id = id;
        this._name;
        this.name = name;
        this._data;
        this.data = data;
    }
    get name() {
        return this._name;
    }
    set name(val) {
        if(typeof val === 'string' || typeof val === 'undefined') {
            this._name = val;
        }
    }
    set id(val) {
        if(typeof val === 'number' || typeof val === 'undefined'){
            this._id = val;
        }
    }
    get id() {
        return this._id;
    }
    set data(val) {
        this._data = val;
    }
    get data() {
        return this._data;
    }
}

export class Positive_number extends Sensor{
    constructor(id, name, data) {
        super(id, name, data);

    }
}

export class Percent extends Sensor{
    constructor(id, name, data) {
        super(id, name, data);
    }
}

export class temperature extends Sensor{
    constructor(id, name, data) {
        super(id, name, data);
    }
}

export class on_off extends Sensor{
    constructor(id, name, data) {
        super(id, name, data);
    }
}

export class open_close extends Sensor{
    constructor(id, name, data) {
        super(id, name, data);
    }
}


export class Data {

}

export class TimeSeries extends Data {
    constructor(values, labels) {
        super();
        this._values;
        this.values = values;
        this._labels;
        this.labels = labels;
    }
    get values() {
        return this._values;
    }
    set values(val) {
        let k = 1;
        let i = 0;
        if(Array.isArray(val)) {
            if(i in val){
                if(!(typeof val[i] === 'number')) {
                    k = 0;
                }
            }
            if(k === 1){
                this._values = val;
            }
        }else if(typeof val === 'undefined'){
            this._values = val;
        }

    }
    set labels(val) {
        let k = 1;
        let i = 0;
        if(Array.isArray(val)) {
            if(i in val){
                if(!(typeof val[i] === 'string')) {
                    k = 0;
                }
            }
            if(k === 1){
                this._labels = val;
            }
        }else if(typeof val === 'undefined'){
            this._labels = val;
        }
    }
    get labels() {
        return this._labels;
    }
}

export class Datum extends Data {
    constructor(value) {
        super();
        this._value;
        this.value = value;
        this._valueArr;
    }
    get value() {
        return this._value;
    }
    set value(val) {
            this._value = val;
    }
}

/*
on cree plein de capteur avec une donnée a chaque fois

 */


/*---------------------------------------------------------*/

export function fData (array) {
    if(typeof array.value.toString() !== 'undefined'){
        return new Datum(array.value);
    }
    else{
        return new TimeSeries(array.values,array.labels);
    }
}

export function fSensorType(data, type) {
    if(type === "POSITIVE_NUMBER"){
        return new Positive_number(data.id, data.name, data.data);
    }
    else if(type === "PERCENT"){
        return new Percent(data.id, data.name, data.data);
    }
    else if(type === "TEMPERATURE"){
        return new temperature(data.id, data.name, data.data);
    }
    else if(type === "ON_OFF"){
        return new on_off(data.id, data.name, data.data);
    }
    else if(type === "OPEN_CLOSE"){
        return new open_close(data.id, data.name, data.data);
    }
}
