package edu.mermet.tp8.fenetres;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.HashMap;
import java.util.Enumeration;

import edu.mermet.tp8.Application;
import edu.mermet.tp8.Preferences;

public class Configuration extends JDialog {

	private Application appli;
	private Preferences preferences;

	private final String auto    = "Auto";
	private final String affiche = "Affich";
	private final String cache   = "Cach";

	private HashMap<String, ButtonGroup> boutons;
	private HashMap<String, String> label;
	
	JPanel panelBoutons = new JPanel();
	JButton valider,annuler;

	private Action actionValider;
	private Action actionAnnuler;

	public Configuration(Application appli, Preferences preferences){
		super(appli, "Configuration des menus", true);
		this.appli = appli;
		this.preferences = preferences;

		boutons = new HashMap<String, ButtonGroup>();
		boutons.put("conversion",  new ButtonGroup());
		boutons.put("saisietexte", new ButtonGroup());
		boutons.put("diaporama",   new ButtonGroup());
		boutons.put("boutons",     new ButtonGroup());

		label = new HashMap<String, String>();
		label.put("conversion", "ConversionCelsuis/Farenheit");
		label.put("saisietexte", "Saisie de texte");
		label.put("diaporama", "Diaporama");
		label.put("boutons", "Boutons");
		
		init();

		setSize(500,200);
		setResizable(false);
		setLocationRelativeTo(appli);
		setVisible(true);
	}

	private void init(){
		JPanel panelChoix = new JPanel();
		panelChoix.setLayout(new GridLayout(4, 4));

		for(String titre : boutons.keySet()){
			ButtonGroup bg = boutons.get(titre);
			JRadioButton autoBt = new JRadioButton(auto, false);
			JRadioButton afficheBt = new JRadioButton(affiche, false);
			JRadioButton cacheBt = new JRadioButton(cache, false);
			bg.add(autoBt);
			bg.add(afficheBt);
			bg.add(cacheBt);
			panelChoix.add(new JLabel(label.get(titre)));
			panelChoix.add(autoBt);
			panelChoix.add(afficheBt);
			panelChoix.add(cacheBt);
		}

		
		panelBoutons.setLayout(new FlowLayout());
		valider = new JButton(new ActionValider(this));
		annuler = new JButton(new ActionAnnuler(this));
		panelBoutons.add(valider);
		panelBoutons.add(annuler);

		add(panelChoix);
		add(panelBoutons, BorderLayout.SOUTH);

		for(String titre : boutons.keySet()){
            Enumeration<AbstractButton> enu = boutons.get(titre).getElements();
            	
			while(enu.hasMoreElements()){
				AbstractButton b = enu.nextElement();
				if(b.getText().equals(preferences.getPreference(titre)))
					b.setSelected(true);
			}
        }

	}


    private class ActionValider extends AbstractAction {
        private Configuration config;
        public ActionValider(Configuration config) {
            super("Valider");
            this.config=config;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            for(String titre : boutons.keySet()){
            	Enumeration<AbstractButton> enu = boutons.get(titre).getElements();
            	
				while(enu.hasMoreElements()){
					AbstractButton b = enu.nextElement();
					if(b.isSelected())
						preferences.setPreference(titre, b.getText());
				}
            }
            preferences.enregistrerPreferences();
            appli.enregistrer();
            config.dispose();
        }
    }

    private class ActionAnnuler extends AbstractAction {
        Configuration config;
        public ActionAnnuler(Configuration config) {
            super("Annuler");
            this.config=config;
            
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            config.dispose();
        }
    }
}
