package edu.mermet.tp8;

import java.util.Properties;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;


public class Preferences {

	private static Preferences preferences;
	private static Properties prop;
	private static String env;
	private static String cheminDossier;
	private static String userPreferences;

	private Preferences(){
		prop = new Properties();
		cheminDossier = System.getProperty("user.home") +"/.ihm";
		userPreferences = System.getProperty("user.home") + "/.ihm/" + System.getProperty("user.name") + ".xml";
	}

	/**
	* Initialise les prfrences selon le fichier HOME/.ihm/preferences.xml
	*/
	public static Preferences getPreferences(){
		try{
			if(Preferences.preferences == null){
				Preferences.preferences = new Preferences();

				if(! Files.isDirectory(Paths.get(cheminDossier))){
					System.out.println("Le repertoire .ihm n'existe pas!Veuillez le crer");
				}

				if(! Files.exists(Paths.get(userPreferences))){
					initialiserPreferences();
				}

				Preferences.prop.loadFromXML(new FileInputStream(new File(userPreferences)));

			}
		}
		catch(Exception e){e.printStackTrace();}
		return Preferences.preferences;
	}

	public void setPreference(String titre, String valeur){
		Preferences.prop.setProperty(titre, valeur);

	}

	public String getPreference(String titre){
		return Preferences.prop.getProperty(titre);
	}

	
	public void enregistrerPreferences(){
		try{
			Preferences.prop.storeToXML(new FileOutputStream(new File(userPreferences)), null);
		}catch(Exception e){e.printStackTrace();}
	}

	
	private static void initialiserPreferences(){
		try{
			Preferences.prop.setProperty("diaporama", "auto");
			Preferences.prop.setProperty("conversion", "auto");
			Preferences.prop.setProperty("boutons", "auto");
			Preferences.prop.setProperty("saisietexte", "auto");

			Preferences.prop.storeToXML(new FileOutputStream(new File(userPreferences)), null);
		}catch(Exception e){e.printStackTrace();}
	}
}
