<?php

require_once 'PlateauSquadro.php';
require_once 'PieceSquadro.php';
require_once 'ArrayPieceSquadro.php';

echo "Début des tests pour la classe PlateauSquadro...\n\n";

// Test 1: Création d'un plateau vide
try {
    $plateau = new PlateauSquadro();
    echo "Test 1: Plateau vide créé avec succès.\n";
    echo "Nombre de lignes jouables: " . count($plateau->getLignesJouables()) . " (devrait être 5)\n";
    echo "Nombre de colonnes jouables: " . count($plateau->getColonnesJouables()) . " (devrait être 5)\n\n";
} catch (Exception $e) {
    echo "Test 1 échoué: " . $e->getMessage() . "\n\n";
}

// Test 2: Récupération d'une pièce valide
try {
    $plateau = new PlateauSquadro();
    $piece = $plateau->getPiece(1, 0); // Pièce blanche Ouest
    echo "Test 2: Pièce récupérée avec succès.\n";
    echo "Couleur de la pièce: " . $piece->getCouleur() . " (devrait être " . PieceSquadro::BLANC . ")\n";
    echo "Direction de la pièce: " . $piece->getDirection() . " (devrait être " . PieceSquadro::OUEST . ")\n\n";
} catch (Exception $e) {
    echo "Test 2 échoué: " . $e->getMessage() . "\n\n";
}

// Test 3: Tentative de récupération d'une pièce avec des coordonnées invalides (doit échouer)
try {
    $plateau = new PlateauSquadro();
    $piece = $plateau->getPiece(999, 999); // Coordonnées invalides
    echo "Test 3 échoué: La récupération aurait dû échouer pour des coordonnées invalides.\n\n";
} catch (Exception $e) {
    echo "Test 3: Récupération d'une pièce avec des coordonnées invalides a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 4: Définition d'une pièce valide
try {
    $plateau = new PlateauSquadro();
    $piece = PieceSquadro::initNoirNord();
    $plateau->setPiece($piece, 1, 1); // Définir une pièce noire Nord à la position (1, 1)
    echo "Test 4: Pièce définie avec succès.\n";
    echo "Couleur de la pièce définie: " . $plateau->getPiece(1, 1)->getCouleur() . " (devrait être " . PieceSquadro::NOIR . ")\n\n";
} catch (Exception $e) {
    echo "Test 4 échoué: " . $e->getMessage() . "\n\n";
}

// Test 5: Tentative de définition d'une pièce avec des coordonnées invalides (doit échouer)
try {
    $plateau = new PlateauSquadro();
    $piece = PieceSquadro::initNoirNord();
    $plateau->setPiece($piece, 999, 999); // Coordonnées invalides
    echo "Test 5 échoué: La définition aurait dû échouer pour des coordonnées invalides.\n\n";
} catch (Exception $e) {
    echo "Test 5: Définition d'une pièce avec des coordonnées invalides a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 6: Retrait d'une ligne jouable
try {
    $plateau = new PlateauSquadro();
    $plateau->retireLigneJouable(1); // Retirer la ligne 1
    echo "Test 6: Ligne jouable retirée avec succès.\n";
    echo "Lignes jouables restantes: " . implode(", ", $plateau->getLignesJouables()) . "\n\n";
} catch (Exception $e) {
    echo "Test 6 échoué: " . $e->getMessage() . "\n\n";
}

// Test 7: Tentative de retrait d'une ligne jouable invalide (doit échouer)
try {
    $plateau = new PlateauSquadro();
    $plateau->retireLigneJouable(999); // Ligne invalide
    echo "Test 7 échoué: Le retrait aurait dû échouer pour une ligne invalide.\n\n";
} catch (Exception $e) {
    echo "Test 7: Retrait d'une ligne jouable invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 8: Retrait d'une colonne jouable
try {
    $plateau = new PlateauSquadro();
    $plateau->retireColonneJouable(1); // Retirer la colonne 1
    echo "Test 8: Colonne jouable retirée avec succès.\n";
    echo "Colonnes jouables restantes: " . implode(", ", $plateau->getColonnesJouables()) . "\n\n";
} catch (Exception $e) {
    echo "Test 8 échoué: " . $e->getMessage() . "\n\n";
}

// Test 9: Tentative de retrait d'une colonne jouable invalide (doit échouer)
try {
    $plateau = new PlateauSquadro();
    $plateau->retireColonneJouable(999); // Colonne invalide
    echo "Test 9 échoué: Le retrait aurait dû échouer pour une colonne invalide.\n\n";
} catch (Exception $e) {
    echo "Test 9: Retrait d'une colonne jouable invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 10: Calcul des coordonnées de destination pour une pièce blanche
try {
    $plateau = new PlateauSquadro();
    $piece = $plateau->getPiece(1, 0); // Pièce blanche Ouest
    list($newX, $newY) = $plateau->getCoordDestination(1, 0);
    echo "Test 10: Coordonnées de destination calculées avec succès.\n";
    echo "Nouvelle position: ($newX, $newY)\n\n";
} catch (Exception $e) {
    echo "Test 10 échoué: " . $e->getMessage() . "\n\n";
}

// Test 11: Calcul des coordonnées de destination pour une pièce noire
try {
    $plateau = new PlateauSquadro();
    $piece = $plateau->getPiece(6, 1); // Pièce noire Sud
    list($newX, $newY) = $plateau->getCoordDestination(6, 1);
    echo "Test 11: Coordonnées de destination calculées avec succès.\n";
    echo "Nouvelle position: ($newX, $newY)\n\n";
} catch (Exception $e) {
    echo "Test 11 échoué: " . $e->getMessage() . "\n\n";
}

// Test 12: Sérialisation en JSON du plateau
try {
    $plateau = new PlateauSquadro();
    $json = $plateau->toJson();
    echo "Test 12: Sérialisation en JSON réussie.\n";
    echo "JSON: " . $json . "\n\n";
} catch (Exception $e) {
    echo "Test 12 échoué: " . $e->getMessage() . "\n\n";
}

// Test 13: Désérialisation d'un plateau à partir de JSON
try {
    $json = '[[{"couleur":0,"direction":7}],[{"couleur":0,"direction":7}],[{"couleur":0,"direction":7}],[{"couleur":0,"direction":7}],[{"couleur":0,"direction":7}],[{"couleur":0,"direction":7}],[{"couleur":0,"direction":7}]]';
    $plateau = PlateauSquadro::fromJson($json);
    echo "Test 13: Désérialisation à partir de JSON réussie.\n";
    echo "Nombre de lignes après désérialisation: " . count($plateau->getPlateau()) . " (devrait être 7)\n\n";
} catch (Exception $e) {
    echo "Test 13 échoué: " . $e->getMessage() . "\n\n";
}

// Test 14: Tentative de désérialisation d'un JSON invalide (doit échouer)
try {
    $json = '[[{"couleur":0,"direction":99}]]'; // Direction invalide
    $plateau = PlateauSquadro::fromJson($json);
    echo "Test 14 échoué: La désérialisation aurait dû échouer pour un JSON invalide.\n\n";
} catch (Exception $e) {
    echo "Test 14: Désérialisation d'un JSON invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

echo "Fin des tests pour la classe PlateauSquadro.\n";
?>