<?php

require_once 'PieceSquadro.php';

echo "Début des tests pour la classe PieceSquadro...\n\n";

// Test 1: Création d'une pièce vide
try {
    $pieceVide = PieceSquadro::initVide();
    echo "Test 1: Pièce vide créée avec succès.\n";
    echo "Couleur: " . $pieceVide->getCouleur() . " (devrait être " . PieceSquadro::VIDE . ")\n";
    echo "Direction: " . $pieceVide->getDirection() . " (devrait être " . PieceSquadro::NORD . ")\n\n";
} catch (Exception $e) {
    echo "Test 1 échoué: " . $e->getMessage() . "\n\n";
}

// Test 2: Création d'une pièce noire Nord
try {
    $pieceNoirNord = PieceSquadro::initNoirNord();
    echo "Test 2: Pièce noire Nord créée avec succès.\n";
    echo "Couleur: " . $pieceNoirNord->getCouleur() . " (devrait être " . PieceSquadro::NOIR . ")\n";
    echo "Direction: " . $pieceNoirNord->getDirection() . " (devrait être " . PieceSquadro::NORD . ")\n\n";
} catch (Exception $e) {
    echo "Test 2 échoué: " . $e->getMessage() . "\n\n";
}

// Test 3: Création d'une pièce noire Sud
try {
    $pieceNoirSud = PieceSquadro::initNoirSud();
    echo "Test 3: Pièce noire Sud créée avec succès.\n";
    echo "Couleur: " . $pieceNoirSud->getCouleur() . " (devrait être " . PieceSquadro::NOIR . ")\n";
    echo "Direction: " . $pieceNoirSud->getDirection() . " (devrait être " . PieceSquadro::SUD . ")\n\n";
} catch (Exception $e) {
    echo "Test 3 échoué: " . $e->getMessage() . "\n\n";
}

// Test 4: Création d'une pièce blanche Est
try {
    $pieceBlancEst = PieceSquadro::initBlancEst();
    echo "Test 4: Pièce blanche Est créée avec succès.\n";
    echo "Couleur: " . $pieceBlancEst->getCouleur() . " (devrait être " . PieceSquadro::BLANC . ")\n";
    echo "Direction: " . $pieceBlancEst->getDirection() . " (devrait être " . PieceSquadro::EST . ")\n\n";
} catch (Exception $e) {
    echo "Test 4 échoué: " . $e->getMessage() . "\n\n";
}

// Test 5: Création d'une pièce blanche Ouest
try {
    $pieceBlancOuest = PieceSquadro::initBlancOuest();
    echo "Test 5: Pièce blanche Ouest créée avec succès.\n";
    echo "Couleur: " . $pieceBlancOuest->getCouleur() . " (devrait être " . PieceSquadro::BLANC . ")\n";
    echo "Direction: " . $pieceBlancOuest->getDirection() . " (devrait être " . PieceSquadro::OUEST . ")\n\n";
} catch (Exception $e) {
    echo "Test 5 échoué: " . $e->getMessage() . "\n\n";
}

// Test 6: Inversion de direction d'une pièce Nord
try {
    $pieceNoirNord = PieceSquadro::initNoirNord();
    $pieceNoirNord->inverseDirection();
    echo "Test 6: Direction de la pièce noire Nord inversée avec succès.\n";
    echo "Nouvelle direction: " . $pieceNoirNord->getDirection() . " (devrait être " . PieceSquadro::SUD . ")\n\n";
} catch (Exception $e) {
    echo "Test 6 échoué: " . $e->getMessage() . "\n\n";
}

// Test 7: Inversion de direction d'une pièce Sud
try {
    $pieceNoirSud = PieceSquadro::initNoirSud();
    $pieceNoirSud->inverseDirection();
    echo "Test 7: Direction de la pièce noire Sud inversée avec succès.\n";
    echo "Nouvelle direction: " . $pieceNoirSud->getDirection() . " (devrait être " . PieceSquadro::NORD . ")\n\n";
} catch (Exception $e) {
    echo "Test 7 échoué: " . $e->getMessage() . "\n\n";
}

// Test 8: Tentative d'inversion de direction d'une pièce Est (doit échouer)
try {
    $pieceBlancEst = PieceSquadro::initBlancEst();
    $pieceBlancEst->inverseDirection();
    echo "Test 8 échoué: L'inversion de direction aurait dû échouer pour une pièce Est.\n\n";
} catch (Exception $e) {
    echo "Test 8: Inversion de direction d'une pièce Est a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 9: Sérialisation en JSON d'une pièce
try {
    $pieceNoirNord = PieceSquadro::initNoirNord();
    $json = $pieceNoirNord->toJson();
    echo "Test 9: Sérialisation en JSON réussie.\n";
    echo "JSON: " . $json . "\n\n";
} catch (Exception $e) {
    echo "Test 9 échoué: " . $e->getMessage() . "\n\n";
}

// Test 10: Désérialisation d'une pièce à partir de JSON
try {
    $json = '{"couleur":1,"direction":4}'; // Pièce noire Nord
    $piece = PieceSquadro::fromJson($json);
    echo "Test 10: Désérialisation à partir de JSON réussie.\n";
    echo "Couleur: " . $piece->getCouleur() . " (devrait être " . PieceSquadro::NOIR . ")\n";
    echo "Direction: " . $piece->getDirection() . " (devrait être " . PieceSquadro::NORD . ")\n\n";
} catch (Exception $e) {
    echo "Test 10 échoué: " . $e->getMessage() . "\n\n";
}

// Test 11: Tentative de désérialisation d'un JSON invalide (doit échouer)
try {
    $json = '{"couleur":1,"direction":99}'; // Direction invalide
    $piece = PieceSquadro::fromJson($json);
    echo "Test 11 échoué: La désérialisation aurait dû échouer pour un JSON invalide.\n\n";
} catch (Exception $e) {
    echo "Test 11: Désérialisation d'un JSON invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

echo "Fin des tests pour la classe PieceSquadro.\n";
?>