<?php

require_once 'ArrayPieceSquadro.php';
require_once 'PieceSquadro.php';

echo "Début des tests pour la classe ArrayPieceSquadro...\n\n";

// Test 1: Création d'un tableau vide
try {
    $arrayPiece = new ArrayPieceSquadro();
    echo "Test 1: Tableau vide créé avec succès.\n";
    echo "Nombre de pièces: " . count($arrayPiece) . " (devrait être 0)\n\n";
} catch (Exception $e) {
    echo "Test 1 échoué: " . $e->getMessage() . "\n\n";
}

// Test 2: Ajout d'une pièce au tableau
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = PieceSquadro::initNoirNord();
    $arrayPiece[] = $piece; // Utilisation de l'interface ArrayAccess
    echo "Test 2: Pièce ajoutée au tableau avec succès.\n";
    echo "Nombre de pièces: " . count($arrayPiece) . " (devrait être 1)\n\n";
} catch (Exception $e) {
    echo "Test 2 échoué: " . $e->getMessage() . "\n\n";
}

// Test 3: Ajout d'une pièce invalide (doit échouer)
try {
    $arrayPiece = new ArrayPieceSquadro();
    $arrayPiece[] = "Ceci n'est pas une pièce"; // Ajout d'une valeur invalide
    echo "Test 3 échoué: L'ajout d'une pièce invalide aurait dû échouer.\n\n";
} catch (Exception $e) {
    echo "Test 3: Ajout d'une pièce invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 4: Récupération d'une pièce par index
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = PieceSquadro::initNoirNord();
    $arrayPiece[] = $piece;
    $recuperee = $arrayPiece[0]; // Utilisation de l'interface ArrayAccess
    echo "Test 4: Pièce récupérée avec succès.\n";
    echo "Couleur de la pièce récupérée: " . $recuperee->getCouleur() . " (devrait être " . PieceSquadro::NOIR . ")\n\n";
} catch (Exception $e) {
    echo "Test 4 échoué: " . $e->getMessage() . "\n\n";
}

// Test 5: Tentative de récupération d'une pièce avec un index invalide (doit échouer)
try {
    $arrayPiece = new ArrayPieceSquadro();
    $recuperee = $arrayPiece[999]; // Index invalide
    echo "Test 5 échoué: La récupération aurait dû échouer pour un index invalide.\n\n";
} catch (Exception $e) {
    echo "Test 5: Récupération d'une pièce avec un index invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 6: Suppression d'une pièce par index
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = PieceSquadro::initNoirNord();
    $arrayPiece[] = $piece;
    unset($arrayPiece[0]); // Utilisation de l'interface ArrayAccess
    echo "Test 6: Pièce supprimée avec succès.\n";
    echo "Nombre de pièces après suppression: " . count($arrayPiece) . " (devrait être 0)\n\n";
} catch (Exception $e) {
    echo "Test 6 échoué: " . $e->getMessage() . "\n\n";
}

// Test 7: Tentative de suppression d'une pièce avec un index invalide (doit échouer)
try {
    $arrayPiece = new ArrayPieceSquadro();
    unset($arrayPiece[999]); // Index invalide
    echo "Test 7 échoué: La suppression aurait dû échouer pour un index invalide.\n\n";
} catch (Exception $e) {
    echo "Test 7: Suppression d'une pièce avec un index invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 8: Ajout de plusieurs pièces et vérification du comptage
try {
    $arrayPiece = new ArrayPieceSquadro();
    $arrayPiece[] = PieceSquadro::initNoirNord();
    $arrayPiece[] = PieceSquadro::initBlancEst();
    $arrayPiece[] = PieceSquadro::initVide();
    echo "Test 8: Plusieurs pièces ajoutées avec succès.\n";
    echo "Nombre de pièces: " . count($arrayPiece) . " (devrait être 3)\n\n";
} catch (Exception $e) {
    echo "Test 8 échoué: " . $e->getMessage() . "\n\n";
}

// Test 9: Sérialisation en JSON du tableau de pièces
try {
    $arrayPiece = new ArrayPieceSquadro();
    $arrayPiece[] = PieceSquadro::initNoirNord();
    $arrayPiece[] = PieceSquadro::initBlancEst();
    $json = $arrayPiece->toJson();
    echo "Test 9: Sérialisation en JSON réussie.\n";
    echo "JSON: " . $json . "\n\n";
} catch (Exception $e) {
    echo "Test 9 échoué: " . $e->getMessage() . "\n\n";
}

// Test 10: Désérialisation d'un tableau de pièces à partir de JSON
try {
    $json = '[{"couleur":1,"direction":4},{"couleur":0,"direction":5}]'; // Pièce noire Nord et pièce blanche Est
    $arrayPiece = ArrayPieceSquadro::fromJson($json);
    echo "Test 10: Désérialisation à partir de JSON réussie.\n";
    echo "Nombre de pièces après désérialisation: " . count($arrayPiece) . " (devrait être 2)\n\n";
} catch (Exception $e) {
    echo "Test 10 échoué: " . $e->getMessage() . "\n\n";
}

// Test 11: Tentative de désérialisation d'un JSON invalide (doit échouer)
try {
    $json = '[{"couleur":1,"direction":99}]'; // Direction invalide
    $arrayPiece = ArrayPieceSquadro::fromJson($json);
    echo "Test 11 échoué: La désérialisation aurait dû échouer pour un JSON invalide.\n\n";
} catch (Exception $e) {
    echo "Test 11: Désérialisation d'un JSON invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

echo "Fin des tests pour la classe ArrayPieceSquadro.\n";
?>