<?php

require_once 'ArrayPieceSquadro.php';
require_once 'PieceSquadro.php';

echo "Début des tests pour la classe ArrayPieceSquadro...\n\n";

// Test 1: Création d'un tableau vide
try {
    $arrayPiece = new ArrayPieceSquadro();
    echo "Test 1: Tableau vide créé avec succès.\n";
    echo "Nombre de pièces: " . count($arrayPiece) . " (devrait être 0)\n\n";
} catch (Exception $e) {
    echo "Test 1 échoué: " . $e->getMessage() . "\n\n";
}

// Test 2: Ajout d'une pièce au tableau
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = PieceSquadro::initNoirNord();
    $arrayPiece[] = $piece;
    echo "Test 2: Pièce ajoutée avec succès.\n";
    echo "Nombre de pièces: " . count($arrayPiece) . " (devrait être 1)\n\n";
} catch (Exception $e) {
    echo "Test 2 échoué: " . $e->getMessage() . "\n\n";
}

// Test 3: Vérification de la validité des données des pièces ajoutées
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = PieceSquadro::initNoirNord();
    $arrayPiece[] = $piece;
    $retrievedPiece = $arrayPiece[0];
    echo "Test 3: Pièce récupérée avec succès.\n";
    echo "Couleur: " . $retrievedPiece->getCouleur() . " (devrait être NOIR)\n";
    echo "Direction: " . $retrievedPiece->getDirection() . " (devrait être NORD)\n\n";
} catch (Exception $e) {
    echo "Test 3 échoué: " . $e->getMessage() . "\n\n";
}

// Test 4: Tentative d'ajout d'un élément non valide
try {
    $arrayPiece = new ArrayPieceSquadro();
    $arrayPiece[] = "Ceci n'est pas une pièce";
    echo "Test 4 échoué: Ajout d'un élément non valide aurait dû échouer.\n\n";
} catch (Exception $e) {
    echo "Test 4: Échec attendu lors de l'ajout d'un élément non valide.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 5: Suppression d'une pièce
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = PieceSquadro::initNoirNord();
    $arrayPiece[] = $piece;
    unset($arrayPiece[0]);
    echo "Test 5: Pièce supprimée avec succès.\n";
    echo "Nombre de pièces: " . count($arrayPiece) . " (devrait être 0)\n\n";
} catch (Exception $e) {
    echo "Test 5 échoué: " . $e->getMessage() . "\n\n";
}

// Test 6: Index invalide lors de la suppression
try {
    $arrayPiece = new ArrayPieceSquadro();
    unset($arrayPiece[99]);
    echo "Test 6 échoué: La suppression avec un index invalide aurait dû échouer.\n\n";
} catch (Exception $e) {
    echo "Test 6: Échec attendu lors de la suppression avec un index invalide.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 7: Désérialisation d'un JSON invalide (doit échouer)
try {
    $json = '[{"couleur":1,"direction":99}]'; // JSON invalide (direction 99 non supportée)
    $arrayPiece = ArrayPieceSquadro::fromJson($json);
    echo "Test 7 échoué: La désérialisation aurait dû échouer pour un JSON invalide.\n\n";
} catch (Exception $e) {
    echo "Test 7: Désérialisation d'un JSON invalide a échoué comme prévu.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 8: Ajout et récupération de plusieurs pièces
try {
    $arrayPiece = new ArrayPieceSquadro();
    $arrayPiece[] = PieceSquadro::initNoirNord();
    $arrayPiece[] = PieceSquadro::initBlancEst();
    $arrayPiece[] = PieceSquadro::initVide();
    echo "Test 8: Ajout de plusieurs pièces réussi.\n";
    foreach ($arrayPiece as $index => $piece) {
        echo "Index $index - Couleur: " . $piece->getCouleur() . ", Direction: " . $piece->getDirection() . "\n";
    }
    echo "\n";
} catch (Exception $e) {
    echo "Test 8 échoué: " . $e->getMessage() . "\n\n";
}

// Test 9: Accès avec un index hors limites
try {
    $arrayPiece = new ArrayPieceSquadro();
    $piece = $arrayPiece[10];
    echo "Test 9 échoué: L'accès à un index hors limites aurait dû échouer.\n\n";
} catch (Exception $e) {
    echo "Test 9: Échec attendu lors de l'accès à un index hors limites.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

// Test 10: Vérification des limites lors de la désérialisation d'un JSON incorrect
try {
    $json = '[{"couleur":1,"direction":99}]';
    $arrayPiece = ArrayPieceSquadro::fromJson($json);
    echo "Test 10 échoué: La désérialisation d'un JSON incorrect aurait dû échouer.\n\n";
} catch (Exception $e) {
    echo "Test 10: Échec attendu lors de la désérialisation d'un JSON incorrect.\n";
    echo "Message d'erreur: " . $e->getMessage() . "\n\n";
}

echo "Fin des tests pour la classe ArrayPieceSquadro.\n";
?>
