<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Confirmation du déplacement</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f0f0f0;
            margin: 0;
        }

        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            width: 300px;
            text-align: center;
        }

        h1 {
            font-size: 1.5em;
            color: #333;
            margin-bottom: 20px;
        }

        .coordinates {
            font-size: 1.2em;
            color: #555;
            margin-bottom: 20px;
        }

        .buttons {
            display: flex;
            justify-content: space-between;
            gap: 10px;
        }

        button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 1em;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button:hover {
            background-color: #0056b3;
        }

        button:disabled {
            background-color: #ccc;
            cursor: not-allowed;
        }
    </style>
</head>
<body>

    <div class="container">
        <h1>Confirmation du déplacement</h1>
        <div class="coordinates">
            <!-- Affichage dynamique des coordonnées -->
            <?php
            if (isset($_GET['x']) && isset($_GET['y'])) {
                $x = (int) $_GET['x'];
                $y = (int) $_GET['y'];
                echo "La pièce sélectionnée se trouve à la position ($x, $y).";
            } else {
                echo "Coordonnées manquantes.";
            }
            ?>
        </div>

        <div class="buttons">
            <form action="move.php" method="POST">
                <button type="submit">Oui</button>
            </form>
            <form action="index.php" method="GET">
                <button type="submit">Non</button>
            </form>
        </div>
    </div>

</body>
</html>
