<?php

require_once 'PieceSquadroUI.php';


class SquadroUIGenerator {

  public static function generateGamePage($activePlayerColor) {
    // Définit une couleur par défaut si la valeur est invalide
    if (!is_string($activePlayerColor) || !in_array($activePlayerColor, ['white', 'black'])) {
        $activePlayerColor = 'white'; // Par défaut, blanc
    }

    $html = "
    <!DOCTYPE html>
    <html lang='fr'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Squadro - Jeu de Société</title>
        <style>
            body {
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                height: 100vh;
                background-color: #f5f5f5;
            }
            .title {
                font-family: 'Arial', sans-serif;
                font-size: 2em;
                font-weight: bold;
                margin-bottom: 20px;
                text-align: center;
                color: #4a4a4a;
            }
            .status {
                width: 300px;
                height: 50px;
                background-color: #e0e0e0;
                border-radius: 10px;
                display: flex;
                justify-content: center;
                align-items: center;
                font-family: 'Arial', sans-serif;
                font-size: 1em;
                color: #4a4a4a;
                margin-bottom: 20px;
            }
            .board {
                display: grid;
                grid-template-columns: repeat(9, 80px);
                grid-template-rows: repeat(9, 80px);
                gap: 5px;
                background-color: #8B5A2B;
                padding: 10px;
                border-radius: 10px;
            }
            .cell {
                width: 80px;
                height: 80px;
                background-color: #D2B48C;
                display: flex;
                justify-content: center;
                align-items: center;
                border-radius: 5px;
                font-family: Arial, sans-serif;
                font-size: 18px;
                color: black;
                font-weight: bold;
            }
            .piece {
                width: 60px;
                height: 60px;
                border-radius: 50%;
            }
            .white { background-color: white; border: 1px solid black; }
            .black { background-color: black; }
            .Limites {
              color: red;
              background-color: red ;
            }
            .CaseValide {
              color : #C0F7F3 ;
              background-color: #C0F7F3 ;
            }
        </style>
    </head>
    <body>

        <div class='title'>Squadro</div>

        <div class='status'>C'est au joueur " . ucfirst($activePlayerColor) . " de jouer</div>

        <div class='board'>
            <!-- Ligne ajoutée en haut -->
            " . self::generateRow(['', '', '3', '1', '2', '1', '3', '', ''], $activePlayerColor, 0) . "
            <!-- Ligne vide déplacée ici -->
            " . self::generateRow(['', 'L', 'V', 'V', 'V', 'V', 'V', 'L', ''], $activePlayerColor, 1) . "
            <!-- Lignes principales avec pièces -->
            " . self::generateRow(['1', 'R', 'V', 'V', 'V', 'V', 'V', 'V', '3'], $activePlayerColor, 2) . "
            " . self::generateRow(['3', 'R', 'V', 'V', 'V', 'V', 'V', 'V', '1'], $activePlayerColor, 3) . "
            " . self::generateRow(['2', 'R', 'V', 'V', 'V', 'V', 'V', 'V', '2'], $activePlayerColor, 4) . "
            " . self::generateRow(['3', 'R', 'V', 'V', 'V', 'V', 'V', 'V', '1'], $activePlayerColor, 5) . "
            " . self::generateRow(['1', 'R', 'V', 'V', 'V', 'V', 'V', 'V', '3'], $activePlayerColor, 6) . "
            <!-- Ligne avec noirs -->
            " . self::generateRow(['', 'L', 'Y', 'Y', 'Y', 'Y', 'Y', 'L', ''], $activePlayerColor, 7) . "
            <!-- Ligne ajoutée en bas -->
            " . self::generateRow(['', '', '1', '3', '2', '3', '1', '', ''], $activePlayerColor, 8) . "
        </div>
    </body>
    </html>
    ";

    return $html;
}

private static function generateRow($cells, $activePlayerColor, $y) {
    $html = "";
    $x = 0; // Coordonnée de départ pour x

    foreach ($cells as $cell) {
        if ($cell === 'L') {
            $html .= PieceSquadroUI::generateNeutralCell();
        } elseif ($cell === 'V') {
            $html .= PieceSquadroUI::generateValidCell();
        } elseif ($cell === 'R') {
            $html .= PieceSquadroUI::generatePieceCell('white', $x, $y, $activePlayerColor === 'white');
        } elseif ($cell === 'Y') {
            $html .= PieceSquadroUI::generatePieceCell('black', $x, $y, $activePlayerColor === 'black');
        } elseif (is_numeric($cell)) {
            // Ajoute un chiffre directement dans une cellule
            $html .= '<button class="cell" disabled>' . htmlspecialchars($cell) . '</button>';
        } else {
            $html .= PieceSquadroUI::generateEmptyCell();
        }

        $x++; // Incrémenter la coordonnée x pour la prochaine cellule
    }

    return $html;
}



}

?>
