<?php

// src/Controller/EtablissementController.php
namespace App\Controller;

use App\Entity\Etablissement;
use App\Repository\EtablissementRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/etablissements')]
class EtablissementController extends AbstractController
{
    #[Route('/departement/{code_departement}', name: 'etablissements_par_departement')]
    public function parDepartement(string $code_departement, EtablissementRepository $repository): Response
    {
        $etablissements = $repository->findBy(['departement' => $code_departement]);

        return $this->render('etablissement/par_departement.html.twig', [
            'etablissements' => $etablissements,
            'departement' => $code_departement,
        ]);
    }

    #[Route('/academie/{code_academie}', name: 'etablissements_par_academie')]
    public function parAcademie(string $code_academie, EtablissementRepository $repository): Response
    {
        $etablissements = $repository->findBy(['academie' => $code_academie]);

        return $this->render('etablissement/par_academie.html.twig', [
            'etablissements' => $etablissements,
            'academie' => $code_academie,
        ]);
    }

    #[Route('/region/{region}', name: 'etablissements_par_region')]
    public function parRegion(string $region, EtablissementRepository $repository): Response
    {
        $etablissements = $repository->findBy(['region' => $region]);

        return $this->render('etablissement/par_region.html.twig', [
            'etablissements' => $etablissements,
            'region' => $region,
        ]);
    }

    #[Route('/commune/{commune}', name: 'etablissements_par_commune')]
    public function parCommune(string $commune, EtablissementRepository $repository): Response
    {
        $etablissements = $repository->findBy(['commune' => $commune]);

        return $this->render('etablissement/par_commune.html.twig', [
            'etablissements' => $etablissements,
            'commune' => $commune,
        ]);
    }
}
