<?php

// src/Controller/EtablissementController.php
namespace App\Controller;

use App\Entity\Etablissement;
use App\Repository\EtablissementRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Doctrine\ORM\Tools\Pagination\Paginator;

#[Route('/etablissements')]
class EtablissementController extends AbstractController
{
    #[Route('/departement/{code_departement}', name: 'etablissements_par_departement')]
    public function parDepartement(string $code_departement, EtablissementRepository $repository, Request $request): Response
    {
        $page = $request->query->getInt('page', 1); // Récupérer la page courante, 1 par défaut
        $limit = 50; // Nombre d'établissements par page
        $offset = ($page - 1) * $limit; // Calcul de l'offset

        // Construire la requête avec un QueryBuilder
        $query = $repository->createQueryBuilder('e')
            ->where('e.code_departement = :code_departement')
            ->setParameter('code_departement', $code_departement)
            ->setFirstResult($offset) // Définir l'offset
            ->setMaxResults($limit)  // Limiter les résultats à la page courante
            ->getQuery();

        // Appliquer la pagination
        $paginator = new Paginator($query);
        $total = count($paginator); // Nombre total d'établissements

        return $this->render('departement.html.twig', [
            'etablissements' => $paginator,
            'departement' => $code_departement,
            'current_page' => $page,
            'total_pages' => ceil($total / $limit), // Nombre total de pages
        ]);
    }

    #[Route('/academie/{code_academie}', name: 'etablissements_par_academie')]
    public function parAcademie(string $code_academie, EtablissementRepository $repository, Request $request): Response
    {
        $page = $request->query->getInt('page', 1);
        $limit = 100;
        $offset = ($page - 1) * $limit;

        $query = $repository->createQueryBuilder('e')
            ->where('e.code_academie = :code_academie')
            ->setParameter('code_academie', $code_academie)
            ->setFirstResult($offset)
            ->setMaxResults($limit)
            ->getQuery();

        $paginator = new Paginator($query);
        $total = count($paginator);

        return $this->render('academie.html.twig', [
            'etablissements' => $paginator,
            'academie' => $code_academie,
            'current_page' => $page,
            'total_pages' => ceil($total / $limit),
        ]);
    }

    #[Route('/region/{region}', name: 'etablissements_par_region')]
    public function parRegion(string $region, EtablissementRepository $repository, Request $request): Response
    {
        $page = $request->query->getInt('page', 1);
        $limit = 100;
        $offset = ($page - 1) * $limit;

        $query = $repository->createQueryBuilder('e')
            ->where('e.code_region = :code_region')
            ->setParameter('code_region', $region)
            ->setFirstResult($offset)
            ->setMaxResults($limit)
            ->getQuery();

        $paginator = new Paginator($query);
        $total = count($paginator);

        return $this->render('region.html.twig', [
            'etablissements' => $paginator,
            'region' => $region,
            'current_page' => $page,
            'total_pages' => ceil($total / $limit),
        ]);
    }

    #[Route('/commune/{commune}', name: 'etablissements_par_commune')]
    public function parCommune(string $commune, EtablissementRepository $repository, Request $request): Response
    {
        $page = $request->query->getInt('page', 1);
        $limit = 50;
        $offset = ($page - 1) * $limit;

        $query = $repository->createQueryBuilder('e')
            ->where('e.code_commune = :code_commune')
            ->setParameter('code_commune', $commune)
            ->setFirstResult($offset)
            ->setMaxResults($limit)
            ->getQuery();

        $paginator = new Paginator($query);
        $total = count($paginator);

        return $this->render('commune.html.twig', [
            'etablissements' => $paginator,
            'commune' => $commune,
            'current_page' => $page,
            'total_pages' => ceil($total / $limit),
        ]);
    }
}
