import './index.css';
import nameGenerator from './name-generator';
import isDef from './is-def';

// Store/retrieve the name in/from a cookie.
const cookies = document.cookie.split(';');
console.log(cookies)
let wsname = cookies.find(function(c) {
  if (c.match(/wsname/) !== null) return true;
  return false;
});
if (isDef(wsname)) {
  wsname = wsname.split('=')[1];
} else {
  wsname = nameGenerator();
  document.cookie = "wsname=" + encodeURIComponent(wsname);
}

// Variables :
var color = "#000";
var width_brush = 5;

// Set the name in the header
document.querySelector('header>p').textContent = decodeURIComponent(wsname);

// Create a WebSocket connection to the server
const ws = new WebSocket("ws://" + window.location.host+ "/socket");

document.addEventListener("DOMContentLoaded", function() {

  // Dessin courant
  var dessinCourant = "canvas"; // par défaut

  // Mon canvas initial
  var canvas = document.getElementById(dessinCourant);

  // Ma souris
  var mouse = {
    click: false,
    move: false,
    pos: {x:0, y:0},
    pos_prec: false
  };

  // Mon context
  var context = canvas.getContext('2d');

  // On obtient une liste de couleurs + possibilité de reset un canvas
  var listCouleurs = document.getElementById('couleurs');
  var resetCanvas = document.getElementById('resetCanvas');

  // Div de la largeur du pinceau/crayon/feutre
  var tailleCrayon = document.getElementById('largeurs_pinceau');

  // Reset la largeur du pinceau/crayon/feutre
  var largeurPinceau = document.getElementById('largeur_pinceau');
  largeurPinceau.value = 5;

  // Bouton nouveau dessin
  var boutonNew = document.getElementById('creerNewCanvas');

  // Taille de nos canvas
  var width = context.canvas.clientWidth;
  var height = context.canvas.clientHeight;

  //var rect = canvas.getBoundingClientRect();

  // Trait arrondi :
  context.lineJoin = 'round';
  context.lineCap = 'round';

  //document.body.onmousedown = function(e) { mouse.click = false; };
  canvas.onmouseout = function(e) {
    if(mouse.click === true) { mouse.click = false; }
  };

  // Lorsque on appuie
  canvas.onmousedown = function(e) { mouse.click = true; };

  // Lorsque lache le click de la souris
  canvas.onmouseup = function(e) { mouse.click = false; };

  // Lorsqu'on deplace la souris sur le canvas
  canvas.onmousemove = function(e) {

    mouse.pos.x = parseFloat((e.clientX - canvas.offsetLeft) - 10) / width;
    mouse.pos.y = parseFloat((e.clientY - canvas.offsetTop) - 10) / height;//e.clientY / height;

    mouse.move = true;
  };

  // Fonction permettant de lire un canvas intégralement
  function lireCanvas(dessinCourant) {
    canvas = document.getElementById(dessinCourant);

    mouse = {
      click: false,
      move: false,
      pos: {x:0, y:0},
      pos_prec: false
    };

    // Notre context
    context = canvas.getContext('2d');

    // Taille de nos canvas
    width = context.canvas.clientWidth;
    height = context.canvas.clientHeight;

    //rect = canvas.getBoundingClientRect();

    // Trait arrondi :
    context.lineJoin = 'round';
    context.lineCap = 'round';

    //document.body.onmousedown = function(e) { mouse.click = false; };
    canvas.onmouseout = function(e) {
      if(mouse.click === true) { mouse.click = false; }
    };

    // Lorsque on appuie
    canvas.onmousedown = function(e) { mouse.click = true; };

    // Lorsque lache le click de la souris
    canvas.onmouseup = function(e) { mouse.click = false; };

    // Lorsqu'on deplace la souris sur le canvas
    canvas.onmousemove = function(e) {

      mouse.pos.x = parseFloat((e.clientX - canvas.offsetLeft) - 10) / width;
      mouse.pos.y = parseFloat((e.clientY - canvas.offsetTop) - 10) / height;

      mouse.move = true;
    };
  }

  // Permet de changer la couleur du crayon/pinceau/feutre
  listCouleurs.onclick = function(e) {

    var couleur = e.target.getAttribute('data-couleur');

    if(couleur !== null) {
      color = couleur;
    }
  }

  // Fonction qui permet de dire au serveur qu'on efface un canvas
  resetCanvas.onclick = function(e) {

    ws.send("clear;" + dessinCourant);
  }

  // Fonction permettant de changer la taille du pinceau/crayon/feutre
  tailleCrayon.onchange = function(e) {

    if(e.target.value !== null) {
      width_brush = e.target.value;
      document.getElementById('output').innerHTML = width_brush + " pixels";
    }
  }

  // On appelle le serveur pour créer un nouveau canvas (Nouveau dessin)
  boutonNew.onclick = function(e) {

    ws.send("newCanvas");
  }

  // Fonction permettant de charger une image (Non utilisé)
  /*function loadImage(e) {
    var base_image = e;
    context.drawImage(base_image, width, height);
  }*/

  // We get notified once connected to the server
  ws.onopen = (event) => {
    console.log("Vous êtes connecté !");
  };

  var listChangement = document.getElementById("listeDessins");

  // Fonction qui permet de créer un canvas
  function createNewCanvas(newCanvas, number) {

    var doc = document.getElementById(newCanvas);
    if(doc === null) {

      // On cree notre nouveau canvas
      var nouveauCanvas = document.createElement("canvas");
      nouveauCanvas.setAttribute("id", newCanvas);

      // On set les attributs suivants : class="canvas" width="800" height="500"
      nouveauCanvas.setAttribute("class", "canvas");
      nouveauCanvas.setAttribute("width", "800");
      nouveauCanvas.setAttribute("height", "500");

      // on le met en caché tant qu'il est pas sélectionné
      nouveauCanvas.style.display = "none";

      // on l'ajoute dans notre liste de dessins disponibles en caché
      var listCanvas = document.getElementById("listCanvas");
      listCanvas.appendChild(nouveauCanvas);

      // on l'ajoute à notre liste déroulante
      var listSelect = document.getElementById("listeDessins");
      var newOption = document.createElement("option");
      newOption.setAttribute("value", newCanvas);
      newOption.textContent = "Dessin n°" + number;

      listSelect.appendChild(newOption); // on l'ajoute dans notre liste

    }
  }

  // Changement de dessin à afficher (Possibilité de dessiner sur plusieurs dessins différent)
  listChangement.onchange = function(e) {

    var lastcanvas = "";
    var newcanvas = "";

    if(e.target.value !== "") {

      if(e.target.value === "canvas") {

         lastcanvas = document.getElementById(dessinCourant);
         newcanvas = document.getElementById(e.target.value);

         lastcanvas.style.display = "none";
         newcanvas.style.display = "inline";

         dessinCourant = e.target.value;

         lireCanvas(dessinCourant);
      }
      else {

        lastcanvas = document.getElementById(dessinCourant);
        newcanvas = document.getElementById(e.target.value);

        lastcanvas.style.display = "none";
        newcanvas.style.display = "inline";

        dessinCourant = e.target.value;

        lireCanvas(dessinCourant);
      }

    }
    else {

    }
  }

  // Listen to messages coming from the server. When it happens, create a new <li> and append it to the DOM.
  ws.onmessage = (event) => {

    // On récupère toutes les données du WebSocket
    var test = event.data.split(";");

    if(test.length > 1) {

      // Stockage mémoire des données dessiner
      if(test[0] === "stockMemory") {

        if(test[2] === "newCanvas") {

          console.log("newCanvas" + test);
          createNewCanvas(test[3], test[4]);
        }
        // Sinon on fait le reste
        else {

          var recuperation = JSON.parse(test[2]);
          var couleur = recuperation.couleur;

          if(recuperation.canvas !== null) {

            var dessinCourant = recuperation.canvas;

            var canvas = document.getElementById(dessinCourant);

            if(canvas === null) {
              // on fait rien
            }
            else {
              var context = canvas.getContext('2d');

              var taille = recuperation.taille;

              recuperation = recuperation.line;

              context.beginPath();
              context.lineWidth = taille;
              context.strokeStyle = couleur;
              context.moveTo(recuperation[0].x * width, recuperation[0].y * height);
              context.lineTo(recuperation[1].x * width, recuperation[1].y * height);
              context.stroke();
            }
          }
        }
      }
      else 
      {
        // Nettoyage du canvas selectionné
        if(test[2] === "clear") {

          var dessinCourant1 = test[3];

          var canvas1 = document.getElementById(dessinCourant1);
          var context1 = canvas1.getContext('2d');
          context1.clearRect(0,0, width, height);
        }
        // Sinon on créé un nouveau (bouton)
        else if(test[2] === "newCanvas") {

          console.log("newCanvas2 " + test);
          createNewCanvas(test[3], test[4]);
        }
        // Sinon pour les autres cas on dessine
        else {

          var line = JSON.parse(test[2]);

          var taille2 = line.taille;
          var couleur2 = line.couleur;

          var dessinCourant2 = line.canvas;

          var canvas2 = document.getElementById(dessinCourant2);
          var context2 = canvas2.getContext('2d');

          line = line.line;

          context2.beginPath();
          context2.lineWidth = 2;
          context2.strokeStyle = couleur2;
    			context2.lineWidth = taille2;
          context2.moveTo(line[0].x * width, line[0].y * height);
          context2.lineTo(line[1].x * width, line[1].y * height);
          context2.stroke();
        }
      }
    }

  };

  // Fonction qui permet de lire en continu les informations transmises
  function loopReader() {

    if(mouse.click && mouse.move && mouse.pos_prev) {

      var obj = { line: [ mouse.pos, mouse.pos_prev ], couleur: color, taille: width_brush, canvas: dessinCourant };

      ws.send(JSON.stringify(obj));
      ws.binaryType = "arraybuffer";
      mouse.move = false;

    }

    mouse.pos_prev = {x: mouse.pos.x, y: mouse.pos.y};
    setTimeout(loopReader, 25);
  }

  loopReader();

});
