var http = require('http'),
  WebSocketServer = require('ws').Server,
  port = 1234,
  host = '0.0.0.0';

// create a new HTTP server to deal with low level connection details (tcp connections, sockets, http handshakes, etc.)
var server = http.createServer();


// create a WebSocket Server on top of the HTTP server to deal with the WebSocket protocol
var wss = new WebSocketServer({
  server: server
});

// create a function to be able do broadcast messages to all WebSocket connected clients
wss.broadcast = function broadcast(message) {
  wss.clients.forEach(function each(client) {
    client.send(message);
  });
};

var canvasAll = [];

var listCanvasDispo = [];

// Register a listener for new connections on the WebSocket.
wss.on('connection', function(client, request) {

  // retrieve the name in the cookies
  var cookies = request.headers.cookie.split(';');
  var wsname = cookies.find((c) => {
    return c.match(/^\s*wsname/) !== null;
  });
  wsname = wsname.split('=')[1];

  // greet the newly connected user
  client.send('Bienvenue, ' + decodeURIComponent(wsname) + '!');

  canvasAll.forEach(function(element) {
    wss.broadcast(element);
  });

  listCanvasDispo.forEach(function(element) {
    wss.broadcast(element);
  });

  // Register a listener on each message of each connection
  client.on('message', function(message) {

    var cli = '[' + decodeURIComponent(wsname) + '] ';

    //console.log(cli + ";" + message);

    var checkIfCanvas = message.split(";");

    if(checkIfCanvas[0] !== "clear"){

      var checkIfCanvas = message.split(";");

      if(checkIfCanvas[0] === "newCanvas"){

        if(listCanvasDispo.length === 0) {
          var newCanvas = "canvas0";
          var numero = "0";
          listCanvasDispo.push("stockMemory;" + cli + ";newCanvas;" + newCanvas + ";" + numero);

        }
        else {

          var newCanvas = "canvas"+listCanvasDispo.length
          var numero = listCanvasDispo.length;

          listCanvasDispo.push("stockMemory;" + cli + ";newCanvas;" + newCanvas + ";" + numero);
        }

        message = "newCanvas;" + newCanvas + ";" + numero;
      }

      canvasAll.push("stockMemory;" + cli + ";" + message);
    }
    else{
      canvasAll = [];
    }

    //console.log(message);
//console.log("message from", cli);
    // when receiving a message, broadcast it to all the connected clients
    wss.broadcast("receiving;" + cli + ";" + message);
    //console.log(message);
  });
});


// http sever starts listening on given host and port.
server.listen(port, host, function() {
  console.log('Listening on ' + server.address().address + ':' + server.address().port);
});

process.on('SIGINT', function() {
  process.exit(0);
});
