# syntax=docker/dockerfile:1
FROM node AS build-env

ADD --keep-git-dir=false https://github.com/digitalinnovationone/vite-react-sample.git /data

WORKDIR /data 

RUN npm install && npm run build

FROM httpd:alpine

COPY --from=build-env /data/dist/ /usr/local/apache2/htdocs/
COPY --from=build-env /data/src/assets/ /usr/local/apache2/htdocs/src/assets/
