FROM debian:buster AS build-tetris

RUN apt update && \
    apt install -y g++ git && \
    git clone https://github.com/fanux/tetris.git && \
    cd tetris/src && \
    g++ *cpp -o game -lpthread -static -ffunction-sections -fdata-sections -Wl,--gc-sections && strip game -s -R .comment -R .gnu.version && \
    mkdir /game && \
    mv game /game/game-tetris

FROM scratch
COPY --from=build-tetris /game /
ENTRYPOINT ["/game-tetris"]