package edu.mermet.tp8;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * Classe permettant de gérer le fichier xml d'un utilisateur
 */
public class XmlUtilisateur {

	private String nom;
	private Properties properties;
	private String chemin;

	/**
	 * Constructeur XmlUtilisateur
	 */
	public XmlUtilisateur() {
		this(System.getProperty("user.name"));
	}

	/**
	 * Constructeur XmlUtilisateur
	 * @param nom
	 */
	public XmlUtilisateur(String nom) {
		this.nom = nom;
		properties = new Properties();
		chemin = "src/main/resources/.ihm/"+ nom +".xml";
		try {
			properties.loadFromXML(new FileInputStream(chemin));
		} catch (IOException e) {
			System.out.println("Fichier utilisateur de "+ nom +" non existant ! Création objet utilisateur avec propriétés vides.");
		}
	}

	/**
	 * Retourne le nom de l'utilisateur
	 * @return String
	 */
	public String getNom() {
		return nom;
	}

	/**
	 * Retourne le chemin sous forme de chaîne
	 * @return String
	 */
	public String getChemin() {
		return chemin;
	}

	/**
	 * Retourne la valeur associée à la clé passée en paramètre
	 * @param cle
	 * @return String
	 */
	public String getProperty(String cle) {
		String retour = properties.getProperty(cle);
		if(retour == null) {
			return "";
		}
		return retour;
	}

	/**
	 * Applique une valeur à une clé
	 * @param cle
	 * @param valeur
	 */
	public void setProperty(String cle, String valeur) {
		properties.setProperty(cle, valeur);
	}

	/**
	 * Enregistre les modifications effectuées dans le même fichier
	 */
	public void enregistrer() {
		try {
			properties.storeToXML(new FileOutputStream(chemin), null);
		} catch (IOException e) {
			System.out.println("Erreur à l'enregistrement du fichier utilisateur.");
		}
	}
}
