package edu.mermet.tp8;

/**
 * Classe gérant le level de l'utilisateur
 */
public class NiveauUtisateur {

	public static final int debutNiveau = 10;
	private int niveau;

	/**
	 * Constructeur NiveauUtisateur
	 */
	public NiveauUtisateur() {
		this(debutNiveau);
	}

	/**
	 * Constructeur NiveauUtisateur
	 * @param niveau
	 */
	public NiveauUtisateur(String niveau) {
		try {
			setNiveau(Integer.parseInt(niveau));
			log("Niveau chargé : "+niveau);
		} catch(NumberFormatException | NullPointerException e) {
			log("Mauvais format pour un integer ("+ niveau +"), le niveau est mis à "+debutNiveau);
			setNiveau(debutNiveau);
		}
	}

	/**
	 * Constructeur NiveauUtisateur
	 * @param niveau
	 */
	public NiveauUtisateur(int niveau) {
		setNiveau(niveau);
	}

	/**
	 * Retourne le niveau de l'utilisateur
	 * @return int
	 */
	public int getNiveau() {
		return niveau;
	}

	/**
	 * Applique un niveau à l'utilisateur
	 * @param niveau
	 */
	public void setNiveau(int niveau) {
		this.niveau = niveau;
	}

	/**
	 * Ajoute le niveau passé en paramètre au niveau actuel de l'utilisateur
	 * @param aNiveau
	 */
	public void add(int aNiveau) {
		setNiveau(aNiveau+getNiveau());
	}


	public void add(int Aniveau, int limit) {
		if(getNiveau() < limit) {
			add(Aniveau);
		}
	}
	
	@Override
	public String toString() {
		return Double.toString(niveau);
	}

	/**
	 * Envoie le message passé en paramètre dans la console
	 * @param msg
	 */
	public void log(String msg) {
		System.out.println("NiveauUtisateur :: "+msg);
	}
}
