package train;

import train.vehicule.Vehicule;
import train.vehicule.Voiture;
import train.vehicule.Wagon;
import train.vehicule.Motrice;

import java.util.LinkedList;

public class Train {

	private static String prochaineImmatriculation = "AAA";
	private String immatriculation;

	private static enum Type {
		VIDE, VOYAGEUR, MARCHANDISE
	};

	private Type type;

	private LinkedList<Vehicule> lkVehicule;

	public Train() {
		immatriculation = prochaineImmatriculation;
		incrementerImmatriculation();

		lkVehicule = new LinkedList<Vehicule>();
		type = Type.VIDE;
	}

	public double calculerPoidsEnChargeMaxi() {
		double charge = 0;

		for (Vehicule v : lkVehicule) {
			charge += v.getPoidsEnChargeMaxi();
		}

		return charge;
	}

	public boolean ajouterVehicule(Vehicule v) {
		if (lkVehicule.size() == 0 && !(v instanceof Motrice) || lkVehicule.size() > 0 && (v instanceof Motrice)) {
			try {
				throw new Exception("vehicule invalide");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		boolean ajoutPossible = false;

		ajoutPossible = ajoutPossible || type == Type.VIDE;
		ajoutPossible = ajoutPossible || (type == Type.VOYAGEUR && v instanceof Voiture);
		ajoutPossible = ajoutPossible || (type == Type.MARCHANDISE && v instanceof Wagon);
		if (ajoutPossible) {
			lkVehicule.add(v);
			if (type == Type.VIDE && v instanceof Voiture) {
				type = Type.VOYAGEUR;

			} else if (type == Type.VIDE && v instanceof Wagon) {

			} else if (type == Type.VIDE && v instanceof Wagon) {
				type = Type.MARCHANDISE;
			}
		}
		return true;
	}

	public String toString() {
		String s = "Train " + immatriculation + " poids total en charge Maxi " + calculerPoidsEnChargeMaxi() + " t\n";

		for (Vehicule v : lkVehicule) {
			s += "   " + v + "\n";
		}

		return s;

	}

	private static void incrementerImmatriculation() {
		int cpt;
		char car;
		String nvImmat = "";
		boolean bContinue = true;

		cpt = 1;

		while (bContinue) {
			car = prochaineImmatriculation.charAt(prochaineImmatriculation.length() - cpt);
			if (car == 'Z') {
				car = 'A';
				cpt++;
			} else {
				car++;
				bContinue = false;
			}

			nvImmat = car + nvImmat;

		}

		for (int i = 0; i < prochaineImmatriculation.length() - cpt; i++) {
			nvImmat = prochaineImmatriculation.charAt(i) + nvImmat;
		}

		prochaineImmatriculation = nvImmat;

	}

	public double poidsAVide() {
		double poids = 0;
		for (Vehicule v : lkVehicule) {
			poids += v.getPoidsAVide();
		}
		return poids;
	}
	
	public double getNbRoues() {
		  int nbRouesTotal = 0;
		  for (Vehicule v : lkVehicule) {
		    nbRouesTotal += v.getNbRoues();
		  }
		  return nbRouesTotal;
	}
}
