package com.example.lecturenfc

import android.app.PendingIntent
import android.content.Intent
import android.database.Cursor
import android.nfc.NfcAdapter
import android.nfc.Tag
import android.os.Bundle
import android.view.View
import android.widget.Button
import android.widget.EditText
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity

class MainActivity : AppCompatActivity() {

    private lateinit var nfcAdapter: NfcAdapter
    private lateinit var textView: TextView
    private lateinit var saisie :EditText
    private lateinit var submit : Button
    private lateinit var dbHelper: DatabaseHelper
    private lateinit var tagId :String

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        nfcAdapter = NfcAdapter.getDefaultAdapter(this)
        textView = findViewById(R.id.textView)
        saisie = findViewById(R.id.editText)
        submit = findViewById<Button>(R.id.validate_button)
        dbHelper = DatabaseHelper(this)

        submit.setOnClickListener{
            val name = saisie.text.toString()
            if(name.isNotEmpty()){
                val db = dbHelper.writableDatabase
                db.execSQL("INSERT into user (id, name) VALUES(?, ?)", arrayOf(tagId, name))
                textView.text = "Utilisateur ajouté : " + name + "\n Waiting for NFC tag..."
                saisie.visibility = View.GONE
                saisie.text.clear()
                submit.visibility = View.GONE
            }
        }

    }



    override fun onResume() {
        super.onResume()
        nfcAdapter.enableForegroundDispatch(this, getPendingIntent(), null, null)
    }

    override fun onPause() {
        super.onPause()
        nfcAdapter.disableForegroundDispatch(this)
    }

    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        if (intent.hasExtra(NfcAdapter.EXTRA_TAG)) {
            val tag = intent.getParcelableExtra<Tag>(NfcAdapter.EXTRA_TAG)
            if(tag!=null) {
                tagId = bytesToHex(tag.id)
                val db = dbHelper.writableDatabase
                val c: Cursor = db.rawQuery("SELECT name FROM user WHERE id = ?", arrayOf(tagId))
                if (c.moveToFirst()) {
                    c.moveToFirst()
                    textView.text = c.getString(0) + "\n Waiting for NFC tag..."
                    //nfcAdapter.enableForegroundDispatch(this, getPendingIntent(), null, null)
                }else{
                    textView.text = "Ajoutez l'utilisateur dans la base"
                    saisie.visibility = View.VISIBLE
                    submit.visibility = View.VISIBLE
                }
                c.close()
                db.close()
            } else {
                textView.text = "Tag not found"
            }
        }
    }

    private fun getPendingIntent(): PendingIntent {
        return PendingIntent.getActivity(
            this, 0, Intent(this, javaClass).addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP), 0
        )
    }

    private fun bytesToHex(bytes: ByteArray): String {
        val hexArray = charArrayOf('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F')
        val hexChars = CharArray(bytes.size * 2)
        var v: Int
        for (j in bytes.indices) {
            v = bytes[j].toInt() and 0xFF
            hexChars[j * 2] = hexArray[v ushr 4]
            hexChars[j * 2 + 1] = hexArray[v and 0x0F]
        }
        return String(hexChars)
    }
}