package com.example.lecturenfc

import android.content.Context
import android.database.sqlite.SQLiteDatabase
import android.database.sqlite.SQLiteOpenHelper

class DatabaseHelper(context: Context) : SQLiteOpenHelper(context, DATABASE_NAME, null, DATABASE_VERSION) {
    companion object {
        // Nom de la base de données
        private const val DATABASE_NAME = "nfcusers.db"
        // Version de la base de données
        private const val DATABASE_VERSION = 1
        // Nom de la table
        private const val TABLE_NAME = "user"
        // Nom des colonnes
        private const val COLUMN_ID = "id"
        private const val COLUMN_NAME = "name"
        // Commande SQL pour créer la table
        private const val SQL_CREATE_ENTRIES = "CREATE TABLE $TABLE_NAME (" +
                "$COLUMN_ID TEXT PRIMARY KEY," +
                "$COLUMN_NAME TEXT)"
    }
    override fun onCreate(db: SQLiteDatabase) {
        db.execSQL(SQL_CREATE_ENTRIES)
    }
    override fun onUpgrade(db: SQLiteDatabase, oldVersion: Int, newVersion: Int) {
        // Code pour mettre à jour la table
        db.execSQL("DROP TABLE IF EXISTS $TABLE_NAME")
        onCreate(db)
    }
}