<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\Entity\PrixMoyen;
use App\Repository\VenteRepository;
use Doctrine\Common\Collections\ArrayCollection;
use EasyRdf\Literal\Date;

class PrixMoyenProvider implements ProviderInterface
{
    private VenteRepository $repository;

    public function __construct(VenteRepository $ventes)
    {
        $this->repository = $ventes;
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        $res = new ArrayCollection();

        $result = $this->repository->createQueryBuilder('v')
            ->where('v.surface > 0')
            ->select('MONTH(v.date) as month, YEAR(v.date) as year, AVG(v.surface) as surface, AVG(v.valeur) as valeur')
            ->groupBy('month')
            ->addGroupBy('year')
            ->orderBy('year', 'ASC')
            ->addOrderBy('month', 'ASC')
            ->getQuery()->getResult();

        foreach ($result as $row) {
            $pm = new PrixMoyen();

            $d = new \DateTime();
            $d->setDate($row['year'], $row['month'], 1);

            $pm->setDate($d);
            $pm->setPrix($row['valeur']/$row['surface']);

            $pm->setSomeText('valeur: ' . $row['valeur'] . ' / surface: ' . $row['surface']);

            $res[] = $pm;
        }

        return $res;
    }
}
